/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.Translator;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class BigDecimalColumn
extends Column {
    private BigDecimal[] values;

    protected BigDecimalColumn(String name, int p, int s, BigDecimal[] values) {
        this.precision = p;
        this.scale = s;
        this.values = values;
    }

    protected BigDecimalColumn(int p, int s) {
        this.values = new BigDecimal[initialBatchCapacity];
        this.precision = p;
        this.scale = s;
    }

    @Override
    void resize(int size) {
        if (size < 0) {
            System.out.println("Negative array size: " + size);
        }
        BigDecimal[] nv = new BigDecimal[size];
        boolean[] vm = new boolean[size];
        int s = this.values.length;
        if (s > size) {
            s = size;
        }
        for (int i = 0; i < s; ++i) {
            vm[i] = this.validMask[i];
            nv[i] = this.values[i];
        }
        for (int j = s; j < size; ++j) {
            vm[j] = false;
        }
        this.values = nv;
        this.validMask = vm;
    }

    @Override
    String getClassName() throws SQLException {
        return "java.math.BigDecimal";
    }

    @Override
    int getDisplaySize() throws SQLException {
        return this.precision + 2;
    }

    @Override
    int getType() {
        return 3;
    }

    @Override
    String getTypeName() {
        return "DECIMAL";
    }

    String toSring() {
        return this.getTypeName() + "(" + this.precision + ", " + this.scale + ")";
    }

    @Override
    Object getObject(int row) throws SQLException {
        return this.getBigDecimal(row);
    }

    @Override
    void setBigDecimal(int row, BigDecimal x) throws SQLException {
        this.values[row] = x;
        this.validMask[row] = x != null;
    }

    @Override
    void setBigDecimal(int row, int s, BigDecimal X) throws SQLException {
        super.setBigDecimal(row, s, X);
    }

    @Override
    void setByte(int row, byte x) throws SQLException {
        this.values[row] = BigDecimal.valueOf(x);
        this.validMask[row] = false;
    }

    @Override
    void setDouble(int row, double x) throws SQLException {
        this.values[row] = new BigDecimal(x);
        this.validMask[row] = true;
    }

    @Override
    void setFloat(int row, float x) throws SQLException {
        this.values[row] = new BigDecimal(x);
        this.validMask[row] = true;
    }

    @Override
    void setInt(int row, int x) throws SQLException {
        this.values[row] = BigDecimal.valueOf(x);
        this.validMask[row] = true;
    }

    @Override
    void setLong(int row, long x) throws SQLException {
        this.values[row] = BigDecimal.valueOf(x);
        this.validMask[row] = true;
    }

    @Override
    void setShort(int row, short x) throws SQLException {
        this.values[row] = BigDecimal.valueOf(x);
        this.validMask[row] = true;
    }

    @Override
    BigDecimal getBigDecimal(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("BigDecimalColumn::getBigDecimal: " + Translator.Accessed_null_value());
        }
        return this.values[row];
    }

    @Override
    double getDouble(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("BigDecimalColumn::getDouble: " + Translator.Accessed_null_value());
        }
        return this.values[row].doubleValue();
    }

    @Override
    float getFloat(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("BigDecimalColumn::getFloat: " + Translator.Accessed_null_value());
        }
        return this.values[row].floatValue();
    }

    @Override
    String getString(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("BigDecimalColumn::getString: " + Translator.Accessed_null_value());
        }
        return this.values[row].toString();
    }

    @Override
    boolean getBoolean(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DecimalColumn::getByte: " + Translator.Accessed_null_value());
        }
        long v = 0L;
        try {
            v = this.values[row].longValue();
        }
        catch (Exception ex) {
            new SQLException("DecimalColumn::getBoolean: " + Translator.Conversion_not_possible() + " " + ex.toString());
        }
        if (v == 0L) {
            return false;
        }
        if (v == 1L) {
            return true;
        }
        throw new SQLException("DecimalColumn::getBoolean: " + Translator.Conversion_not_possible());
    }

    @Override
    int getInt(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("BigDecimalColumn::getInt: " + Translator.Accessed_null_value());
        }
        return this.values[row].intValue();
    }

    @Override
    long getLong(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("BigDecimalColumn::getLong: " + Translator.Accessed_null_value());
        }
        return this.values[row].longValue();
    }

    @Override
    short getShort(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("BigDecimalColumn::getShort: " + Translator.Accessed_null_value());
        }
        return this.values[row].shortValue();
    }

    @Override
    byte getByte(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("BigDecimalColumn::getByte: " + Translator.Accessed_null_value());
        }
        return this.values[row].byteValue();
    }

    @Override
    long value_to_jdbc(EXAOutputStream os, int row) throws SQLException, IOException {
        if (this.validMask[row]) {
            os.writeByte((byte)1);
            if (this.scale == this.values[row].scale()) {
                os.writeBigInteger(this.values[row].unscaledValue());
            } else {
                os.writeBigInteger(this.values[row].unscaledValue().multiply(new BigInteger("10").pow(this.scale - this.values[row].scale())));
            }
            return 17L;
        }
        os.writeByte((byte)0);
        return 1L;
    }

    @Override
    void value_from_jdbc(EXAInputStream is, int row) throws SQLException, IOException {
        if (is.nextIsNull()) {
            this.validMask[row] = false;
        } else {
            this.validMask[row] = true;
            this.values[row] = new BigDecimal(is.readBigInteger(), this.scale);
        }
    }

    static Column from_jdbc_type(EXAInputStream is) throws IOException {
        int p = is.readInt();
        int s = is.readInt();
        return new BigDecimalColumn(p, s);
    }

    @Override
    int getEXAType() {
        return 64;
    }

    @Override
    boolean isSigned() throws SQLException {
        return true;
    }
}

