/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXABatchUpdateException;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAHandle;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.EXARowCount;
import com.exasol.jdbc.EXASQLException;
import com.exasol.jdbc.EXAStatement;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.NoResultException;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.ProtocolAttribute;
import com.exasol.jdbc.ServerCommunication;
import com.exasol.jdbc.Translator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;

public abstract class AbstractEXAStatement
extends ServerCommunication
implements Statement {
    protected Vector commands;
    protected int fetchSize;
    protected int fetchDirection;
    protected int maxFieldSize = 0;
    protected int queryTimeout = 0;
    protected int resultSetConcurrency = 10;
    protected int resultSetType;
    protected long maxRows = 0L;
    private int activeProtocolVersion = 14;
    SQLWarning warning;
    protected ExecutionStatus execStatus = null;
    protected EXAResult[] results = null;
    protected boolean IsClosed = false;
    protected int current_result;
    private int metadataSQL = 0;
    protected boolean isPoolable = false;

    @Override
    public boolean isClosed() {
        return this.IsClosed;
    }

    AbstractEXAStatement(EXAConnection c) {
        super(c.getDebug(), "EXAStatement", c);
        this.log("EXAStatement() created.");
        this.commands = new Vector();
        this.fetchSize = c.getDefaultFetchSize();
        this.activeProtocolVersion = c.getActiveProtocolVersion();
        try {
            this.metadataSQL = Integer.parseInt(this.connection.getParameter("metadataSQL"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.metadataSQL != 0) {
            this.metadataSQL = 1;
        }
    }

    AbstractEXAStatement(EXAConnection c, int resultSetType_, int resultSetConcurrency_) {
        this(c);
        this.resultSetConcurrency = resultSetConcurrency_;
        this.resultSetType = resultSetType_;
    }

    public int getActiveProtocolVersion() {
        return this.activeProtocolVersion;
    }

    public synchronized ResultSet GetKeywords() throws SQLException {
        this.log("GetKeywords()");
        if (0 != this.metadataSQL) {
            return this.executeQuery("select KEYWORD from EXA_SQL_KEYWORDS /*Keywords from jdbc*/");
        }
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)120, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    public synchronized ResultSet GetCommands() throws SQLException {
        this.log("GetCommands()");
        if (0 != this.metadataSQL) {
            return this.executeQuery("select \"COMMAND\",\"IS_PLSQL\" from \"$ODBCJDBC\".\"SQL_COMMANDS\" order by \"COMMAND\" /*Commands from jdbc*/");
        }
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)121, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    public synchronized ResultSet GetDbMetadata(String[] names, String stat) throws SQLException {
        this.log("GetDbMetadata(" + names + ", " + stat + ")");
        if (0 != this.metadataSQL) {
            String nameList = "";
            String statVal = "";
            String where = "";
            String and = "";
            if (names != null) {
                nameList = " \"NAME\" in (";
                for (int i = 0; i < names.length; ++i) {
                    nameList = nameList + "'" + names[i] + "'";
                    if (i >= names.length - 1) continue;
                    nameList = nameList + ", ";
                }
                nameList = nameList + ") ";
            }
            if (stat != null) {
                statVal = " \"STATIC\"=" + stat;
            }
            if (nameList.length() > 0 || statVal.length() > 0) {
                where = " WHERE ";
            }
            if (nameList.length() > 0 && statVal.length() > 0) {
                and = " AND ";
            }
            String sql = "select \"NAME\",\"VALUE\",\"STATIC\" from \"$ODBCJDBC\".\"DB_METADATA\" " + where + nameList + and + statVal + " order by 1";
            return this.executeQuery(sql + " /*DbMetadata from jdbc*/");
        }
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        int boolStat = -1;
        if (null != stat && stat.equals("true")) {
            boolStat = 1;
        }
        if (null != stat && stat.equals("false")) {
            boolStat = 0;
        }
        try {
            if (null == names) {
                os.writeInt(-1);
            } else {
                for (int i = 0; i < names.length; ++i) {
                    os.writeInt(names[i].getBytes(this.connection.getEncoding()).length);
                    os.write(names[i].getBytes(this.connection.getEncoding()));
                }
                os.writeInt(-1);
            }
            if (null == stat) {
                os.writeInt(-1);
            } else {
                os.writeInt(boolStat);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)122, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    public synchronized ResultSet GetAllObjects() throws SQLException {
        this.log("GetAllObjects()");
        if (0 != this.metadataSQL) {
            return this.executeQuery("select \"OBJECT_NAME\", \"OBJECT_TYPE\", \"OBJECT_ID\", \"ROOT_ID\", \"LAST_COMMIT\", \"CREATED\", \"OWNER\", \"OBJECT_COMMENT\", \"OBJECT_IS_VIRTUAL\"  from \"SYS\".\"EXA_ALL_OBJECTS\" where \"ROOT_ID\" IS NULL order by \"OBJECT_ID\" /*AllObjects from jdbc*/");
        }
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)123, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    public synchronized ResultSet GetAllUsers() throws SQLException {
        this.log("GetAllUsers()");
        if (0 != this.metadataSQL) {
            return this.executeQuery("select USER_NAME, 0 as USER_ID, CREATED, USER_COMMENT from SYS.EXA_ALL_USERS order by USER_NAME /*AllUsers from jdbc*/");
        }
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)124, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    public synchronized ResultSet GetDbaRoles() throws SQLException {
        this.log("GetDbaRoles()");
        if (0 != this.metadataSQL) {
            return this.executeQuery("select ROLE_NAME as ROLE, -1 as ROLE_ID, ROLE_COMMENT, CREATED from SYS.EXA_DBA_ROLES order by ROLE_NAME /*DbaRoles from jdbc*/");
        }
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)125, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    public synchronized ResultSet GetDbaConnections() throws SQLException {
        this.log("GetDbaConnections()");
        if (0 != this.metadataSQL) {
            return this.executeQuery("select CONNECTION_NAME, CONNECTION_STRING, USER_NAME, CREATED,CONNECTION_COMMENT from SYS.EXA_DBA_CONNECTIONS /*DbaConnections from jdbc*/");
        }
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)126, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.log("addBatch(" + sql + ")");
        this.commands.add(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.log("cancel()");
        if (null != this.execStatus) {
            this.execStatus.cancel();
        } else {
            this.log("nothing to cancel");
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.log("clearBatch()");
        this.commands.clear();
    }

    @Override
    public void clearWarnings() {
        this.log("clearWarnings");
    }

    @Override
    public synchronized void close() throws SQLException {
        this.log("close()");
        if (this.IsClosed) {
            this.log("   Warning: statement was closed before.");
        }
        try {
            if (this.results != null) {
                this.closeResultSets(this.results);
                this.results = null;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.IsClosed = true;
        }
    }

    private ProtocolAttribute[] CreateMaxRowsAttribute() {
        if (this.maxRows > 0L && this.activeProtocolVersion >= 16) {
            ProtocolAttribute attr = new ProtocolAttribute(ProtocolAttribute.ATTR_RESULT_MAX_ROWS.id);
            attr.value = this.maxRows;
            ProtocolAttribute[] attribs = new ProtocolAttribute[]{attr};
            return attribs;
        }
        return null;
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        this.log("execute(" + sql + ")");
        this.connection.setSchemaMayHaveChanged();
        this.execStatus = new ExecutionStatus();
        try {
            this.results = this.connection.communication_resultset(sql.getBytes(this.connection.getEncoding()), (byte)12, this.execStatus, this.CreateMaxRowsAttribute());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.current_result = 0;
        if (this.results != null && this.results.length > 0) {
            if (this.results[0] instanceof EXASQLException) {
                throw ((EXASQLException)this.results[0]).getSQLExceptionIntern(this.connection);
            }
            return this.results[0] instanceof EXAResultSet;
        }
        return false;
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        this.log("executeBatch()");
        int[] retVal = null;
        long[] returnVal = null;
        returnVal = this.exaExecuteLargeBatch();
        if (returnVal != null) {
            retVal = new int[returnVal.length];
            for (int i = 0; i < returnVal.length; ++i) {
                retVal[i] = (int)returnVal[i];
            }
        }
        return retVal;
    }

    public synchronized long[] exaExecuteLargeBatch() throws SQLException {
        this.log("exaExecuteLargeBatch()");
        Throwable lastException = null;
        this.connection.setSchemaMayHaveChanged();
        this.execStatus = new ExecutionStatus();
        this.results = this.connection.communication_vector(this.commands, (byte)17, this.execStatus, this.CreateMaxRowsAttribute());
        if (this.results.length > 0) {
            long[] returnVal = new long[this.results.length];
            for (int i = 0; i < this.results.length; ++i) {
                if (this.results[i] instanceof EXARowCount) {
                    returnVal[i] = ((EXARowCount)this.results[i]).getLongRowCount();
                    continue;
                }
                if (this.results[i] instanceof EXASQLException) {
                    long[] tmpRetVal = new long[this.results.length - 1];
                    System.arraycopy(returnVal, 0, tmpRetVal, 0, this.results.length - 1);
                    returnVal = tmpRetVal;
                    lastException = ((EXASQLException)this.results[i]).getSQLExceptionIntern(this.connection);
                    continue;
                }
                returnVal[i] = -2L;
            }
            if (lastException != null) {
                throw new EXABatchUpdateException(lastException.getMessage(), ((SQLException)lastException).getSQLState(), ((SQLException)lastException).getErrorCode(), returnVal, lastException);
            }
            return returnVal;
        }
        return null;
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        this.log("executeQuery(" + sql + ")");
        this.connection.setSchemaMayHaveChanged();
        if (this.execute(sql)) {
            if (this.results.length == 0) {
                throw new SQLException(Translator.Query_did_not_return_a_result());
            }
            if (this.results.length > 1) {
                throw new SQLException(Translator.Query_returned_more_than_one_result());
            }
            ResultSet ret = this.getResultSet();
            ret.setFetchSize(this.getFetchSize());
            return ret;
        }
        throw new SQLException(Translator.Query_returned_update_count());
    }

    long exaExecuteLargeUpdate(String sql) throws SQLException {
        this.log("exaExecuteLargeUpdate(" + sql + ")");
        this.connection.setSchemaMayHaveChanged();
        if (this.execute(sql)) {
            throw new SQLException(Translator.Statement_returned_resultset());
        }
        long result = this.getLongUpdateCount();
        if (result < 0L) {
            return 0L;
        }
        return result;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() {
        if (this.debug != null) {
            this.log("EXAStatement:getFetchSize(): " + this.fetchSize);
        }
        if (this.fetchSize <= 0) {
            if (this.debug != null) {
                this.log("Ignoring invalid fetch size: " + this.fetchSize + ". Fetch size will be set to connection default: " + this.connection.getDefaultFetchSize());
            }
            this.fetchSize = this.connection.getDefaultFetchSize();
        }
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.debug != null) {
            this.debug.log("getGeneratedKys()");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() {
        return (int)this.maxRows;
    }

    @Override
    public long getLargeMaxRows() {
        return this.maxRows;
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        this.log("getMoreResults()");
        if (this.results == null || this.current_result >= this.results.length) {
            return false;
        }
        if (this.current_result > 0 && this.results[this.current_result] instanceof EXAResultSet) {
            EXAResultSet res = (EXAResultSet)this.results[this.current_result];
            res.close();
        }
        ++this.current_result;
        if (this.current_result >= this.results.length) {
            return false;
        }
        if (this.results[this.current_result] instanceof EXASQLException) {
            return false;
        }
        return this.results[this.current_result] instanceof EXAResultSet;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        this.log("getResultSet()");
        if (this.results == null || this.current_result >= this.results.length) {
            throw new NoResultException();
        }
        if (this.results[this.current_result] instanceof EXAResultSet) {
            ((EXAResultSet)this.results[this.current_result]).setMaxRows(this.maxRows);
            EXAResultSet result = (EXAResultSet)this.results[this.current_result];
            result.setStatement((EXAStatement)this);
            result.setFetchSize(this.getFetchSize());
            return result;
        }
        if (this.results[this.current_result] instanceof EXAHandle && this.current_result < this.results.length - 1 && this.results[this.current_result + 1] instanceof EXASQLException) {
            ++this.current_result;
        }
        if (this.results[this.current_result] instanceof EXASQLException) {
            throw ((EXASQLException)this.results[this.current_result]).getSQLExceptionIntern(this.connection);
        }
        return null;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getUpdateCount() throws SQLException {
        long luc = (int)this.getLongUpdateCount();
        if (luc > Integer.MAX_VALUE) {
            luc = Integer.MAX_VALUE;
        }
        this.log("getUpdateCount() - " + luc);
        return (int)luc;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        long luc = this.getLongUpdateCount();
        this.log("getLargeUpdateCount() - " + luc);
        return luc;
    }

    public synchronized long getLongUpdateCount() throws SQLException {
        long myResult = -1L;
        if (this.results != null && this.current_result < this.results.length) {
            if (this.results[this.current_result] instanceof EXASQLException) {
                throw ((EXASQLException)this.results[this.current_result]).getSQLExceptionIntern(this.connection);
            }
            if (this.results[this.current_result] instanceof EXARowCount) {
                myResult = ((EXARowCount)this.results[this.current_result]).getLongRowCount();
            }
        }
        return myResult;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warning;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String name)");
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
        this.log("setEscapeProcessing(" + enable + ")");
    }

    @Override
    public void setFetchDirection(int direction) {
        this.log("setFetchDirection(" + direction + ")");
        this.fetchDirection = direction;
    }

    @Override
    public void setFetchSize(int kilobytes) {
        this.log("setFetchSize(): " + kilobytes);
        if (kilobytes <= 0) {
            this.fetchSize = this.connection.getDefaultFetchSize();
            this.log(" Fetch size set to default: " + this.fetchSize);
        } else if (kilobytes > 65536) {
            this.fetchSize = 65536;
            this.log("Fetch size set to max: " + this.fetchSize);
        } else {
            this.fetchSize = kilobytes;
        }
    }

    @Override
    public void setMaxFieldSize(int max) {
        this.log("setMaxFieldSize(" + max + ")");
        this.maxFieldSize = max;
    }

    @Override
    public void setMaxRows(int max) {
        this.log("setMaxRows(" + max + ")");
        this.maxRows = max < 0 ? 0L : (long)max;
    }

    @Override
    public void setLargeMaxRows(long max) {
        this.log("setLargeMaxRows(" + max + ")");
        this.maxRows = max < 0L ? 0L : max;
    }

    @Override
    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        this.log("setQueryTimeout(" + seconds + ")");
        this.queryTimeout = seconds;
    }

    protected void closeResultSets(EXAResult[] resultSets) throws SQLException {
        if (null == resultSets) {
            this.log("closeResultSets(null)");
            return;
        }
        this.log("closeResultSets() - resultSets.length: " + resultSets.length);
        if (null == resultSets) {
            return;
        }
        this.execStatus = new ExecutionStatus();
        int numberOfResults = 0;
        for (int i = 0; i < resultSets.length; ++i) {
            if (!(resultSets[i] instanceof EXAResultSet) || ((EXAResultSet)resultSets[i]).GetHandle() < 0) continue;
            ++numberOfResults;
        }
        if (numberOfResults > 0) {
            byte[] to_send = new byte[4 * numberOfResults];
            int n = 0;
            int i = 0;
            do {
                if (!(resultSets[i] instanceof EXAResultSet) || ((EXAResultSet)resultSets[i]).GetHandle() < 0) continue;
                to_send[4 * n + 0] = (byte)((EXAResultSet)resultSets[i]).GetHandle();
                to_send[4 * n + 1] = (byte)(((EXAResultSet)resultSets[i]).GetHandle() >> 8);
                to_send[4 * n + 2] = (byte)(((EXAResultSet)resultSets[i]).GetHandle() >> 16);
                to_send[4 * n + 3] = (byte)(((EXAResultSet)resultSets[i]).GetHandle() >> 24);
                this.log("Closing result with handle: " + ((EXAResultSet)resultSets[i]).GetHandle());
                ((EXAResultSet)resultSets[i]).setHandle(-1);
                ++n;
            } while (n < numberOfResults && ++i < resultSets.length);
            if (n != numberOfResults) {
                throw new SQLException("something is wrong");
            }
            this.connection.communication(to_send, (byte)13, this.execStatus, null);
        }
    }

    public String getSQLTypeName(int type) {
        switch (type) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 2004: {
                return "BLOB";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "UNKNOWN TYPE";
    }

    public int getNumberOfResults() {
        int n = 0;
        if (this.results != null) {
            n = this.results.length;
        }
        this.log("getNumberOfResults() - " + n);
        return n;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.log("setPoolable(" + poolable + ")");
        this.isPoolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.log("isPoolable() - " + this.isPoolable);
        return this.isPoolable;
    }
}

