/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.MoreIterables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class FormatterProperties {
    private final Properties properties = new Properties();

    private FormatterProperties() {
    }

    public static FormatterProperties from(File ... files) throws IllegalArgumentException {
        Objects.requireNonNull(files);
        return FormatterProperties.from(Arrays.asList(files));
    }

    public static FormatterProperties from(Iterable<File> files) throws IllegalArgumentException {
        List<File> nonNullFiles = MoreIterables.toNullHostileList(files);
        FormatterProperties properties = new FormatterProperties();
        nonNullFiles.forEach(properties::add);
        return properties;
    }

    private void add(File settingsFile) throws IllegalArgumentException {
        Objects.requireNonNull(settingsFile);
        if (!settingsFile.isFile() || !settingsFile.canRead()) {
            String msg = String.format("Settings file '%s' does not exist or can not be read.", settingsFile);
            throw new IllegalArgumentException(msg);
        }
        try {
            Properties newSettings = FileParser.parse(settingsFile);
            this.properties.putAll((Map<?, ?>)newSettings);
        }
        catch (IOException | IllegalArgumentException exception) {
            String message = String.format("Failed to add properties from '%s' to formatter settings.", settingsFile);
            String detailedMessage = exception.getMessage();
            if (null != detailedMessage) {
                message = message + String.format(" %s", detailedMessage);
            }
            throw new IllegalArgumentException(message, exception);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    private static enum XmlParser {
        PROPERTIES("properties"){

            @Override
            protected Properties execute(File xmlFile, Node rootNode) throws IOException, IllegalArgumentException {
                Properties properties = new Properties();
                try (FileInputStream xmlInput = new FileInputStream(xmlFile);){
                    properties.loadFromXML(xmlInput);
                }
                return properties;
            }
        }
        ,
        PROFILES("profiles"){

            @Override
            protected Properties execute(File file, Node rootNode) throws IOException, IllegalArgumentException {
                Properties properties = new Properties();
                Node firstProfile = this.getSingleProfile(rootNode);
                Iterator<Node> iterator = this.getChildren(firstProfile, "setting").iterator();
                while (iterator.hasNext()) {
                    Node settingObj;
                    Node setting = settingObj = iterator.next();
                    NamedNodeMap attributes = setting.getAttributes();
                    Node id = attributes.getNamedItem("id");
                    Node value = attributes.getNamedItem("value");
                    if (null == id) {
                        throw new IllegalArgumentException("Node 'setting' does not possess an 'id' attribute.");
                    }
                    String idString = id.getNodeValue();
                    String valString = null == value ? "" : value.getNodeValue();
                    properties.setProperty(idString, valString);
                }
                return properties;
            }

            private Node getSingleProfile(Node rootNode) throws IllegalArgumentException {
                List<Node> profiles = this.getChildren(rootNode, "profile");
                if (profiles.isEmpty()) {
                    throw new IllegalArgumentException("The formatter configuration profile files does not contain any 'profile' elements.");
                }
                if (profiles.size() > 1) {
                    String message = "Formatter configuration file contains multiple profiles: [";
                    message = message + profiles.stream().map(x$0 -> XmlParser.getProfileName(x$0)).collect(Collectors.joining("; "));
                    message = message + "]%n The formatter can only cope with a single profile per configuration file. Please remove the other profiles.";
                    throw new IllegalArgumentException(message);
                }
                return profiles.iterator().next();
            }

            private List<Node> getChildren(Node node, String nodeName) {
                NodeList children = node.getChildNodes();
                return IntStream.range(0, children.getLength()).mapToObj(children::item).filter(child -> child.getNodeName().equals(nodeName)).collect(Collectors.toCollection(LinkedList::new));
            }
        };

        private final String rootNodeName;

        private static String getProfileName(Node profile) {
            Node nameAttribute = profile.getAttributes().getNamedItem("name");
            return null == nameAttribute ? "" : nameAttribute.getNodeValue();
        }

        private XmlParser(String rootNodeName) {
            this.rootNodeName = rootNodeName;
        }

        public String toString() {
            return this.rootNodeName;
        }

        protected abstract Properties execute(File var1, Node var2) throws IOException, IllegalArgumentException;

        public static Properties parse(File file, Node rootNode) throws IOException, IllegalArgumentException {
            String rootNodeName = rootNode.getNodeName();
            for (XmlParser parser : XmlParser.values()) {
                if (!parser.rootNodeName.equals(rootNodeName)) continue;
                return parser.execute(file, rootNode);
            }
            String msg = String.format("The XML root node '%1$s' is not part of the supported root nodes [%2$s].", rootNodeName, Arrays.toString((Object[])XmlParser.values()));
            throw new IllegalArgumentException(msg);
        }
    }

    private static enum FileParser {
        LINE_ORIENTED(new String[]{"properties", "prefs"}){

            @Override
            protected Properties execute(File file) throws IOException, IllegalArgumentException {
                Properties properties = new Properties();
                try (FileInputStream inputProperties = new FileInputStream(file);){
                    properties.load(inputProperties);
                }
                return properties;
            }
        }
        ,
        XML(new String[]{"xml"}){

            @Override
            protected Properties execute(File file) throws IOException, IllegalArgumentException {
                Node rootNode = this.getRootNode(file);
                String nodeName = rootNode.getNodeName();
                if (null == nodeName) {
                    throw new IllegalArgumentException("XML document does not contain a root node.");
                }
                return XmlParser.parse(file, rootNode);
            }

            private Node getRootNode(File file) throws IOException, IllegalArgumentException {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setFeature(FileParser.LOAD_EXTERNAL_DTD_PROP, false);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    return db.parse(file).getDocumentElement();
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw new IllegalArgumentException("File has no valid XML syntax.", e);
                }
            }
        };

        private static final String LOAD_EXTERNAL_DTD_PROP = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        private static final char FILE_EXTENSION_SEPARATOR = '.';
        private final List<String> supportedFileNameExtensions;

        private FileParser(String ... supportedFileNameExtensions) {
            this.supportedFileNameExtensions = Arrays.asList(supportedFileNameExtensions);
        }

        protected abstract Properties execute(File var1) throws IOException, IllegalArgumentException;

        public static Properties parse(File file) throws IOException, IllegalArgumentException {
            String fileNameExtension = FileParser.getFileNameExtension(file);
            for (FileParser parser : FileParser.values()) {
                if (!parser.supportedFileNameExtensions.contains(fileNameExtension)) continue;
                return parser.execute(file);
            }
            String msg = String.format("The file name extension '%1$s' is not part of the supported file extensions [%2$s].", fileNameExtension, Arrays.toString((Object[])FileParser.values()));
            throw new IllegalArgumentException(msg);
        }

        private static String getFileNameExtension(File file) {
            String fileName = file.getName();
            int seperatorPos = fileName.lastIndexOf(46);
            return 0 > seperatorPos ? "" : fileName.substring(seperatorPos + 1);
        }
    }
}

