/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.xwpf.IdenifierManagerWrapper;
import com.deepoove.poi.xwpf.NumberingWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFNum;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTInline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBody;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocument1;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STNumberFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiceXWPFDocument
extends XWPFDocument {
    private static Logger logger = LoggerFactory.getLogger(NiceXWPFDocument.class);
    protected List<XWPFTable> allTables = new ArrayList<XWPFTable>();
    protected List<XWPFPicture> allPictures = new ArrayList<XWPFPicture>();
    protected IdenifierManagerWrapper idenifierManagerWrapper;
    protected boolean adjustDoc = false;

    public NiceXWPFDocument() {
    }

    public NiceXWPFDocument(InputStream in) throws IOException {
        this(in, false);
    }

    public NiceXWPFDocument(InputStream in, boolean adjustDoc) throws IOException {
        super(in);
        this.adjustDoc = adjustDoc;
        this.idenifierManagerWrapper = new IdenifierManagerWrapper(this);
        this.myDocumentRead();
    }

    protected void onDocumentCreate() {
        super.onDocumentCreate();
        try {
            CTDocument1 ctDocument = this.getDocument();
            CTDocument1 parse = null;
            String doc = "<xml-fragment xmlns:wpc=\"http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas\" \n    xmlns:mo=\"http://schemas.microsoft.com/office/mac/office/2008/main\" \n    xmlns:mc=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" \n    xmlns:mv=\"urn:schemas-microsoft-com:mac:vml\" \n    xmlns:o=\"urn:schemas-microsoft-com:office:office\" \n    xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" \n    xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\" \n    xmlns:v=\"urn:schemas-microsoft-com:vml\" \n    xmlns:wp14=\"http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing\" \n    xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" \n    xmlns:w10=\"urn:schemas-microsoft-com:office:word\" \n    xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" \n    xmlns:w14=\"http://schemas.microsoft.com/office/word/2010/wordml\" \n    xmlns:wpg=\"http://schemas.microsoft.com/office/word/2010/wordprocessingGroup\" \n    xmlns:wpi=\"http://schemas.microsoft.com/office/word/2010/wordprocessingInk\" \n    xmlns:wne=\"http://schemas.microsoft.com/office/word/2006/wordml\" \n    xmlns:wps=\"http://schemas.microsoft.com/office/word/2010/wordprocessingShape\" mc:Ignorable=\"w14 wp14\"><w:body></w:body></xml-fragment>";
            parse = CTDocument1.Factory.parse((String)doc);
            ctDocument.set((XmlObject)parse);
        }
        catch (XmlException e) {
            logger.warn("Create new document error and merge docx may produce bug: {}", (Object)e.getMessage());
        }
    }

    private void myDocumentRead() {
        this.initAllElement((IBody)this);
        this.getHeaderList().forEach(header -> this.initAllElement((IBody)header));
        this.getFooterList().forEach(header -> this.initAllElement((IBody)header));
    }

    private void initAllElement(IBody body) {
        this.readParagraphs(body.getParagraphs());
        this.readTables(body.getTables());
    }

    private void readParagraphs(List<XWPFParagraph> paragraphs) {
        paragraphs.forEach(paragraph -> paragraph.getRuns().forEach(run -> this.readRun((XWPFRun)run)));
    }

    private void readRun(XWPFRun run) {
        this.allPictures.addAll(run.getEmbeddedPictures());
        if (!this.idenifierManagerWrapper.isValid()) {
            return;
        }
        CTR r = run.getCTR();
        XmlObject[] xmlObjects = r.selectPath("declare namespace w='http://schemas.openxmlformats.org/wordprocessingml/2006/main' \n        declare namespace mc='http://schemas.openxmlformats.org/markup-compatibility/2006' .//mc:AlternateContent/mc:Choice/w:drawing");
        if (null == xmlObjects || xmlObjects.length <= 0) {
            return;
        }
        for (XmlObject xmlObject : xmlObjects) {
            try {
                long reserve;
                long id;
                CTDrawing ctDrawing = CTDrawing.Factory.parse((String)xmlObject.xmlText());
                for (CTAnchor anchor : ctDrawing.getAnchorList()) {
                    if (anchor.getDocPr() == null) continue;
                    id = anchor.getDocPr().getId();
                    reserve = this.idenifierManagerWrapper.reserve(id);
                    if (!this.adjustDoc || id == reserve) continue;
                    anchor.getDocPr().setId(reserve);
                    xmlObject.set((XmlObject)ctDrawing);
                }
                for (CTInline inline : ctDrawing.getInlineList()) {
                    if (inline.getDocPr() == null) continue;
                    id = inline.getDocPr().getId();
                    reserve = this.idenifierManagerWrapper.reserve(id);
                    if (!this.adjustDoc || id == reserve) continue;
                    inline.getDocPr().setId(reserve);
                    xmlObject.set((XmlObject)ctDrawing);
                }
            }
            catch (XmlException xmlException) {
                // empty catch block
            }
        }
    }

    private void readTables(List<XWPFTable> tables) {
        this.allTables.addAll(tables);
        for (XWPFTable table : tables) {
            List rows = table.getRows();
            if (null == rows) continue;
            for (XWPFTableRow row : rows) {
                List cells = row.getTableCells();
                if (null == cells) continue;
                for (XWPFTableCell cell : cells) {
                    this.initAllElement((IBody)cell);
                }
            }
        }
    }

    public List<XWPFPicture> getAllEmbeddedPictures() {
        return Collections.unmodifiableList(this.allPictures);
    }

    public List<XWPFTable> getAllTables() {
        return Collections.unmodifiableList(this.allTables);
    }

    public IdenifierManagerWrapper getDocPrIdenifierManager() {
        return this.idenifierManagerWrapper;
    }

    public BigInteger addNewNumbericId(Pair<STNumberFormat.Enum, String> numFmt) {
        XWPFNumbering numbering = this.getNumbering();
        if (null == numbering) {
            numbering = this.createNumbering();
        }
        NumberingWrapper numberingWrapper = new NumberingWrapper(numbering);
        CTAbstractNum cTAbstractNum = CTAbstractNum.Factory.newInstance();
        cTAbstractNum.setAbstractNumId(numberingWrapper.getNextAbstractNumID());
        STNumberFormat.Enum fmt = (STNumberFormat.Enum)numFmt.getLeft();
        String val = (String)numFmt.getRight();
        CTLvl cTLvl = cTAbstractNum.addNewLvl();
        cTLvl.addNewNumFmt().setVal(fmt);
        cTLvl.addNewLvlText().setVal(val);
        cTLvl.addNewStart().setVal(BigInteger.valueOf(1L));
        cTLvl.setIlvl(BigInteger.valueOf(0L));
        if (fmt == STNumberFormat.BULLET) {
            cTLvl.addNewLvlJc().setVal(STJc.LEFT);
        }
        XWPFAbstractNum abstractNum = new XWPFAbstractNum(cTAbstractNum);
        BigInteger abstractNumID = numbering.addAbstractNum(abstractNum);
        return numbering.addNum(abstractNumID);
    }

    public NiceXWPFDocument generate() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(byteArrayOutputStream);
        this.close();
        return new NiceXWPFDocument(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    public NiceXWPFDocument generateWithAdjust() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(byteArrayOutputStream);
        this.close();
        return new NiceXWPFDocument(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), true);
    }

    public NiceXWPFDocument merge(Iterator<NiceXWPFDocument> iterator, XWPFRun run) throws Exception {
        if (null == iterator || !iterator.hasNext() || null == run) {
            return this;
        }
        XWPFParagraph paragraph = (XWPFParagraph)run.getParent();
        CTP ctp = paragraph.getCTP();
        CTBody body = this.getDocument().getBody();
        String srcString = body.xmlText();
        if (!srcString.startsWith("<xml-fragment")) {
            body.addNewSectPr();
            srcString = body.xmlText();
        }
        String prefix = srcString.substring(0, srcString.indexOf(">") + 1);
        String sufix = srcString.substring(srcString.lastIndexOf("<"));
        List<String> addParts = this.convertStr(iterator);
        iterator = null;
        CTP makeBody = CTP.Factory.parse((String)(prefix + StringUtils.join(addParts, (String)"") + sufix));
        ctp.set((XmlObject)makeBody);
        String xmlText = body.xmlText();
        xmlText = xmlText.replaceAll("<w:p><w:p>", "<w:p>").replaceAll("<w:p><w:p\\s", "<w:p ").replaceAll("<w:p><w:tbl>", "<w:tbl>").replaceAll("<w:p><w:tbl\\s", "<w:tbl ");
        xmlText = xmlText.replaceAll("</w:sectPr></w:p>", "</w:sectPr>").replaceAll("</w:p></w:p>", "</w:p>").replaceAll("</w:tbl></w:p>", "</w:tbl>").replaceAll("<w:p(\\s[A-Za-z0-9:\\s=\"]*)?/></w:p>", "").replaceAll("</w:p><w:bookmarkEnd(\\s[A-Za-z0-9:\\s=\"]*)?/></w:p>", "</w:p>");
        body.set((XmlObject)CTBody.Factory.parse((String)xmlText));
        return this.generateWithAdjust();
    }

    public NiceXWPFDocument merge(NiceXWPFDocument docMerge) throws Exception {
        return this.merge(Arrays.asList(docMerge), this.createParagraph().createRun());
    }

    public NiceXWPFDocument merge(List<NiceXWPFDocument> docMerges, XWPFRun run) throws Exception {
        if (null == docMerges || docMerges.isEmpty() || null == run) {
            return this;
        }
        return this.merge(docMerges.iterator(), run);
    }

    private List<String> convertStr(Iterator<NiceXWPFDocument> iterator) throws InvalidFormatException {
        ArrayList<String> strList = new ArrayList<String>();
        NiceXWPFDocument next = iterator.next();
        Map<String, String> styleMapCache = this.mergeStyles(next);
        while (true) {
            strList.add(this.extractMergePart(next, styleMapCache));
            if (!iterator.hasNext()) break;
            next = iterator.next();
        }
        return strList;
    }

    private String extractMergePart(NiceXWPFDocument docMerge, Map<String, String> styleIdsMap) throws InvalidFormatException {
        CTBody bodyMerge = docMerge.getDocument().getBody();
        Map<BigInteger, BigInteger> numIdsMap = this.mergeNumbering(docMerge);
        Map<String, String> blipIdsMap = this.mergePicture(docMerge);
        Map<String, String> hyperlinkMap = this.mergeHyperlink(docMerge);
        Map<String, String> chartIdsMap = this.mergeChart(docMerge);
        XmlOptions optionsOuter = new XmlOptions();
        optionsOuter.setSaveOuter();
        String appendString = bodyMerge.xmlText(optionsOuter);
        String addPart = this.ridSectPr(appendString);
        for (String string : styleIdsMap.keySet()) {
            addPart = addPart.replaceAll("<w:pStyle\\sw:val=\"" + string + "\"", "<w:pStyle w:val=\"" + styleIdsMap.get(string) + "\"").replaceAll("<w:tblStyle\\sw:val=\"" + string + "\"", "<w:tblStyle w:val=\"" + styleIdsMap.get(string) + "\"").replaceAll("<w:rStyle\\sw:val=\"" + string + "\"", "<w:rStyle w:val=\"" + styleIdsMap.get(string) + "\"");
        }
        HashMap<String, String> placeHolderblipIdsMap = new HashMap<String, String>();
        for (String relaId : blipIdsMap.keySet()) {
            placeHolderblipIdsMap.put(relaId, blipIdsMap.get(relaId) + "@PoiTL@");
        }
        for (String relaId : placeHolderblipIdsMap.keySet()) {
            addPart = addPart.replaceAll("r:embed=\"" + relaId + "\"", "r:embed=\"" + (String)placeHolderblipIdsMap.get(relaId) + "\"");
            addPart = addPart.replaceAll("r:id=\"" + relaId + "\"", "r:id=\"" + (String)placeHolderblipIdsMap.get(relaId) + "\"");
        }
        for (String relaId : hyperlinkMap.keySet()) {
            hyperlinkMap.put(relaId, hyperlinkMap.get(relaId) + "@PoiTL@");
        }
        for (String relaId : hyperlinkMap.keySet()) {
            addPart = addPart.replaceAll("r:id=\"" + relaId + "\"", "r:id=\"" + hyperlinkMap.get(relaId) + "\"");
        }
        for (String relaId : chartIdsMap.keySet()) {
            chartIdsMap.put(relaId, chartIdsMap.get(relaId) + "@PoiTL@");
        }
        for (String relaId : chartIdsMap.keySet()) {
            addPart = addPart.replaceAll("r:id=\"" + relaId + "\"", "r:id=\"" + chartIdsMap.get(relaId) + "\"");
        }
        HashMap<BigInteger, String> hashMap = new HashMap<BigInteger, String>();
        for (BigInteger relaId : numIdsMap.keySet()) {
            hashMap.put(relaId, numIdsMap.get(relaId) + "@PoiTL@");
        }
        for (BigInteger numId : hashMap.keySet()) {
            addPart = addPart.replaceAll("<w:numId\\sw:val=\"" + numId + "\"", "<w:numId w:val=\"" + (String)hashMap.get(numId) + "\"");
        }
        addPart = addPart.replaceAll("@PoiTL@", "");
        try {
            docMerge.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return addPart;
    }

    private String ridSectPr(String appendString) {
        int lastIndexOf = appendString.lastIndexOf("<w:sectPr");
        String addPart = "";
        int begin = appendString.indexOf(">") + 1;
        int end = appendString.lastIndexOf("<");
        if (-1 != lastIndexOf) {
            String prefix = appendString.substring(begin, appendString.lastIndexOf("<w:sectPr"));
            String sufix = appendString.substring(appendString.lastIndexOf("</w:sectPr>") + 11, end);
            return prefix + sufix;
        }
        if (begin < end) {
            addPart = appendString.substring(begin, end);
        }
        return addPart;
    }

    private Map<String, String> mergePicture(NiceXWPFDocument docMerge) throws InvalidFormatException {
        HashMap<String, String> blipIdsMap = new HashMap<String, String>();
        List allPictures = docMerge.getAllPictures();
        for (XWPFPictureData xwpfPictureData : allPictures) {
            String relationId = docMerge.getRelationId((POIXMLDocumentPart)xwpfPictureData);
            String blidId = this.addPictureData(xwpfPictureData.getData(), xwpfPictureData.getPictureType());
            blipIdsMap.put(relationId, blidId);
        }
        return blipIdsMap;
    }

    private Map<BigInteger, BigInteger> mergeNumbering(NiceXWPFDocument docMerge) {
        HashMap<BigInteger, BigInteger> numIdsMap = new HashMap<BigInteger, BigInteger>();
        XWPFNumbering numberingMerge = docMerge.getNumbering();
        if (null == numberingMerge) {
            return numIdsMap;
        }
        NumberingWrapper wrapperMerge = new NumberingWrapper(numberingMerge);
        List<XWPFNum> nums = wrapperMerge.getNums();
        if (null == nums) {
            return numIdsMap;
        }
        XWPFNumbering numbering = this.getNumbering();
        if (null == numbering) {
            numbering = this.createNumbering();
        }
        NumberingWrapper wrapper = new NumberingWrapper(numbering);
        HashMap<BigInteger, CTAbstractNum> cache = new HashMap<BigInteger, CTAbstractNum>();
        for (XWPFNum xwpfNum : nums) {
            BigInteger mergeNumId = xwpfNum.getCTNum().getNumId();
            CTAbstractNum cTAbstractNum = (CTAbstractNum)cache.get(xwpfNum.getCTNum().getAbstractNumId().getVal());
            if (null == cTAbstractNum) {
                XWPFAbstractNum xwpfAbstractNum = numberingMerge.getAbstractNum(xwpfNum.getCTNum().getAbstractNumId().getVal());
                if (null == xwpfAbstractNum) {
                    logger.warn("cannot find cTAbstractNum by XWPFNum.");
                    continue;
                }
                cTAbstractNum = xwpfAbstractNum.getCTAbstractNum();
                cTAbstractNum.setAbstractNumId(wrapper.getNextAbstractNumID());
                if (cTAbstractNum.isSetNsid()) {
                    cTAbstractNum.unsetNsid();
                }
                if (cTAbstractNum.isSetTmpl()) {
                    cTAbstractNum.unsetTmpl();
                }
                cache.put(xwpfNum.getCTNum().getAbstractNumId().getVal(), cTAbstractNum);
            }
            BigInteger numID = numbering.addNum(numbering.addAbstractNum(new XWPFAbstractNum(cTAbstractNum)));
            numIdsMap.put(mergeNumId, numID);
        }
        return numIdsMap;
    }

    private Map<String, String> mergeStyles(NiceXWPFDocument docMerge) {
        XWPFStyles stylesMerge;
        HashMap<String, String> styleIdsMap = new HashMap<String, String>();
        XWPFStyles styles = this.getStyles();
        if (null == styles) {
            styles = this.createStyles();
        }
        if (null == (stylesMerge = docMerge.getStyles())) {
            return styleIdsMap;
        }
        try {
            Field listStyleField = XWPFStyles.class.getDeclaredField("listStyle");
            listStyleField.setAccessible(true);
            List lists = (List)listStyleField.get(stylesMerge);
            for (XWPFStyle xwpfStyle : lists) {
                if (styles.styleExist(xwpfStyle.getStyleId())) {
                    String id = xwpfStyle.getStyleId();
                    xwpfStyle.setStyleId(UUID.randomUUID().toString());
                    styleIdsMap.put(id, xwpfStyle.getStyleId());
                }
                styles.addStyle(xwpfStyle);
            }
        }
        catch (Exception e) {
            logger.error("merge style error", (Throwable)e);
        }
        return styleIdsMap;
    }

    private Map<String, String> mergeHyperlink(NiceXWPFDocument docMerge) throws InvalidFormatException {
        HashMap<String, String> map = new HashMap<String, String>();
        PackageRelationshipCollection hyperlinks = docMerge.getPackagePart().getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
        for (PackageRelationship relationship : hyperlinks) {
            PackageRelationship relationshipNew = this.getPackagePart().addExternalRelationship(relationship.getTargetURI().toString(), XWPFRelation.HYPERLINK.getRelation());
            map.put(relationship.getId(), relationshipNew.getId());
        }
        return map;
    }

    private Map<String, String> mergeChart(NiceXWPFDocument docMerge) throws InvalidFormatException {
        HashMap<String, String> map = new HashMap<String, String>();
        return map;
    }

    public int getPosOfParagraphCTP(CTP bodyObj) {
        for (int i = 0; i < this.bodyElements.size(); ++i) {
            IBodyElement current = (IBodyElement)this.bodyElements.get(i);
            if (current.getElementType() != BodyElementType.PARAGRAPH || !((XWPFParagraph)current).getCTP().equals(bodyObj)) continue;
            return i;
        }
        return -1;
    }

    public int getPosOfTableCTTbl(CTTbl bodyObj) {
        for (int i = 0; i < this.bodyElements.size(); ++i) {
            IBodyElement current = (IBodyElement)this.bodyElements.get(i);
            if (current.getElementType() != BodyElementType.TABLE || !((XWPFTable)current).getCTTbl().equals(bodyObj)) continue;
            return i;
        }
        return -1;
    }

    public int getParaPos(XWPFParagraph insertNewParagraph) {
        for (int i = 0; i < this.paragraphs.size(); ++i) {
            if (this.paragraphs.get(i) != insertNewParagraph) continue;
            return i;
        }
        return -1;
    }

    public int getTablePos(XWPFTable insertNewTbl) {
        for (int i = 0; i < this.tables.size(); ++i) {
            if (this.tables.get(i) != insertNewTbl) continue;
            return i;
        }
        return -1;
    }

    public void updateBodyElements(IBodyElement insertNewParagraph, IBodyElement copy) {
        int pos = -1;
        for (int i = 0; i < this.bodyElements.size(); ++i) {
            if (this.bodyElements.get(i) != insertNewParagraph) continue;
            pos = i;
        }
        if (-1 != pos) {
            this.bodyElements.set(pos, copy);
        }
    }
}

