/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render.processor;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.DocxRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.render.compute.RenderDataCompute;
import com.deepoove.poi.render.processor.DefaultTemplateProcessor;
import com.deepoove.poi.resolver.Resolver;
import com.deepoove.poi.template.run.RunTemplate;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementProcessor
extends DefaultTemplateProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementProcessor.class);

    public ElementProcessor(XWPFTemplate template, Resolver resolver, RenderDataCompute renderDataCompute) {
        super(template, resolver, renderDataCompute);
    }

    @Override
    public void visit(RunTemplate runTemplate) {
        RenderPolicy policy = runTemplate.findPolicy(this.template.getConfig());
        if (null == policy) {
            throw new RenderException("Cannot find render policy: [" + runTemplate.getTagName() + "]");
        }
        if (policy instanceof DocxRenderPolicy) {
            return;
        }
        LOGGER.info("Start render TemplateName:{}, Sign:{}, policy:{}", new Object[]{runTemplate.getTagName(), runTemplate.getSign(), ClassUtils.getShortClassName(policy.getClass())});
        policy.render(runTemplate, this.renderDataCompute.compute(runTemplate.getTagName()), this.template);
    }
}

