/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.logging.log4j.status;

import com.databricks.client.jdbc42.internal.apache.logging.log4j.Level;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.Logger;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.message.ParameterizedNoReferenceMessageFactory;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.status.SimpleLoggerFactory;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.status.StatusData;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.status.StatusListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;

public class StatusConsoleListener
implements StatusListener {
    private Level level;
    private String[] filters;
    private final PrintStream stream;
    private final Logger logger;

    public StatusConsoleListener(Level level) {
        this(level, System.out);
    }

    public StatusConsoleListener(Level level, PrintStream stream) {
        this(level, stream, SimpleLoggerFactory.getInstance());
    }

    StatusConsoleListener(Level level, PrintStream stream, SimpleLoggerFactory loggerFactory) {
        this.level = Objects.requireNonNull(level, "level");
        this.stream = Objects.requireNonNull(stream, "stream");
        this.logger = Objects.requireNonNull(loggerFactory, "loggerFactory").createSimpleLogger("StatusConsoleListener", level, ParameterizedNoReferenceMessageFactory.INSTANCE, stream);
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    @Override
    public Level getStatusLevel() {
        return this.level;
    }

    @Override
    public void log(StatusData data) {
        boolean filtered = this.filtered(data);
        if (!filtered) {
            this.logger.atLevel(data.getLevel()).withThrowable(data.getThrowable()).withLocation(data.getStackTraceElement()).log(data.getMessage());
        }
    }

    public void setFilters(String ... filters) {
        this.filters = filters;
    }

    private boolean filtered(StatusData data) {
        if (this.filters == null) {
            return false;
        }
        String caller = data.getStackTraceElement().getClassName();
        for (String filter : this.filters) {
            if (!caller.startsWith(filter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.stream != System.out && this.stream != System.err) {
            this.stream.close();
        }
    }
}

