/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.rw;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.enums.RWSite;
import dm.jdbc.util.MathUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public class RWCounter {
    private static Boolean rwMapMutex = new Boolean(true);
    private static HashMap rwMap = new HashMap();
    private long NTRX_PRIMARY = 0L;
    private long NTRX_TOTAL = 0L;
    private double primaryPercent = 0.0;
    private double standbyPercent = 0.0;
    private HashMap standbyNTrxMap = new HashMap();
    private HashMap standbyIdMap = new HashMap();
    private int standbyCount;
    private Random random = new Random();
    int[] flag = null;
    private int[] increments;

    private RWCounter(int n2, int n3) {
        this.reset(n2, n3);
    }

    private synchronized void reset(int n2, int n3) {
        this.NTRX_PRIMARY = 0L;
        this.NTRX_TOTAL = 0L;
        this.standbyCount = n3;
        this.increments = new int[n3 + 1];
        this.increments[0] = n2 * n3;
        Arrays.fill(this.increments, 1, this.increments.length, 100 - n2);
        this.increments = MathUtil.divis(this.increments);
        this.flag = Arrays.copyOf(this.increments, this.increments.length);
        if (n3 > 0) {
            this.primaryPercent = (double)n2 / 100.0;
            this.standbyPercent = (double)(100 - n2) / 100.0 / (double)n3;
        } else {
            this.primaryPercent = 1.0;
            this.standbyPercent = 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RWCounter getInstance(DmdbConnection dmdbConnection, int n2) {
        String string = String.valueOf(dmdbConnection.host) + "_" + dmdbConnection.port + "_" + dmdbConnection.rwPercent;
        RWCounter rWCounter = null;
        Boolean bl = rwMapMutex;
        synchronized (bl) {
            rWCounter = (RWCounter)rwMap.get(string);
            if (rWCounter == null) {
                rWCounter = new RWCounter(dmdbConnection.rwPercent, n2);
                rwMap.put(string, rWCounter);
            } else if (rWCounter.standbyCount != n2) {
                rWCounter.reset(dmdbConnection.rwPercent, n2);
            }
        }
        return rWCounter;
    }

    public synchronized RWSite countPrimary() {
        this.adjustNtrx();
        this.incrementPrimaryNtrx();
        return RWSite.PRIMARY;
    }

    public synchronized RWSite count(RWSite rWSite, DmdbConnection dmdbConnection) {
        this.adjustNtrx();
        switch (rWSite) {
            case ANY: {
                if (this.primaryPercent == 1.0 || this.flag[0] > this.getStandbyFlag(dmdbConnection) && (long)this.flag[0] > MathUtil.sum(this.flag, 1, this.flag.length)) {
                    this.incrementPrimaryNtrx();
                    rWSite = RWSite.PRIMARY;
                    break;
                }
                this.incrementStandbyNtrx(dmdbConnection);
                rWSite = RWSite.STANDBY;
                break;
            }
            case STANDBY: {
                this.incrementStandbyNtrx(dmdbConnection);
                break;
            }
            case PRIMARY: {
                this.incrementPrimaryNtrx();
                break;
            }
            default: {
                DBError.throwRuntimeException("Invalid RWSite!");
            }
        }
        return rWSite;
    }

    private synchronized void adjustNtrx() {
        if (this.NTRX_TOTAL >= Long.MAX_VALUE) {
            long l2 = MathUtil.min(this.standbyNTrxMap.values());
            l2 = l2 < this.NTRX_PRIMARY ? l2 : this.NTRX_PRIMARY;
            this.NTRX_PRIMARY /= l2;
            this.NTRX_TOTAL /= l2;
            Iterator iterator = this.standbyNTrxMap.entrySet().iterator();
            Map.Entry entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                this.standbyNTrxMap.put((String)entry.getKey(), (Long)entry.getValue() / l2);
            }
        }
        if (this.flag[0] <= 0 && MathUtil.sum(this.flag, 1, this.flag.length) <= 0L) {
            MathUtil.sum(this.flag, this.increments);
        }
    }

    private void incrementPrimaryNtrx() {
        ++this.NTRX_PRIMARY;
        this.flag[0] = this.flag[0] - 1;
        ++this.NTRX_TOTAL;
    }

    private synchronized long getStandbyNtrx(DmdbConnection dmdbConnection) {
        String string = String.valueOf(dmdbConnection.host) + ":" + dmdbConnection.port;
        Long l2 = (Long)this.standbyNTrxMap.get(string);
        return l2 != null ? l2 : 0L;
    }

    private synchronized int getStandbyId(DmdbConnection dmdbConnection) {
        String string = String.valueOf(dmdbConnection.host) + ":" + dmdbConnection.port;
        Integer n2 = (Integer)this.standbyIdMap.get(string);
        if (n2 == null) {
            n2 = this.standbyIdMap.size() + 1;
            if (n2 > this.standbyCount) {
                return -1;
            }
            this.standbyIdMap.put(string, n2);
        }
        return n2;
    }

    private synchronized int getStandbyFlag(DmdbConnection dmdbConnection) {
        int n2 = this.getStandbyId(dmdbConnection);
        if (n2 > 0 && n2 < this.flag.length) {
            return this.flag[n2];
        }
        return 0;
    }

    private synchronized void incrementStandbyNtrx(DmdbConnection dmdbConnection) {
        long l2;
        String string = String.valueOf(dmdbConnection.host) + ":" + dmdbConnection.port;
        Long l3 = (Long)this.standbyNTrxMap.get(string);
        if (l3 != null) {
            l3 = l3 + 1L;
            l2 = l3;
        } else {
            l2 = 1L;
        }
        l3 = l2;
        this.standbyNTrxMap.put(string, l3);
        Integer n2 = (Integer)this.standbyIdMap.get(string);
        if (n2 == null) {
            n2 = this.standbyIdMap.size() + 1;
            this.standbyIdMap.put(string, n2);
        }
        int n3 = n2;
        this.flag[n3] = this.flag[n3] - 1;
        ++this.NTRX_TOTAL;
    }

    public int random(int n2) {
        return this.random.nextInt(n2 > this.standbyCount ? this.standbyCount : n2);
    }

    public String toString() {
        return "PERCENT(P/S) : " + this.primaryPercent + "/" + this.standbyPercent + "\nNTRX_PRIMARY : " + this.NTRX_PRIMARY + "\nNTRX_TOTAL : " + this.NTRX_TOTAL + "\nNTRX_STANDBY : " + this.standbyNTrxMap.toString();
    }

    public static void main(String[] stringArray) {
        RWCounter rWCounter = new RWCounter(60, 3);
        rWCounter.NTRX_PRIMARY = 200L;
        rWCounter.NTRX_TOTAL = Long.MAX_VALUE;
        rWCounter.standbyNTrxMap.put("1", 3634L);
        rWCounter.standbyNTrxMap.put("2", 363L);
        rWCounter.standbyNTrxMap.put("3", 34L);
        rWCounter.adjustNtrx();
        System.out.println(rWCounter.toString());
    }
}

