/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.processor;

import dm.jdbc.processor.BaseThread;
import dm.jdbc.util.ByteArray;
import dm.jdbc.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Date;

public abstract class BaseFlusher
extends BaseThread {
    protected String date = new Date(System.currentTimeMillis()).toString();
    protected File logFile = null;
    protected FileOutputStream out;
    protected String filePrefix;
    protected int flushFreq;
    protected String filePath;
    public static final int MAX_FILE_SIZE = 0x6400000;
    public static final int FLUSH_SIZE = 32768;
    protected ByteArray buffer = new ByteArray();

    public BaseFlusher(String threadName, String filePath, String filePrefix, int flushFreq) {
        super(threadName);
        this.filePath = filePath;
        this.filePrefix = filePrefix;
        this.flushFreq = flushFreq;
    }

    protected abstract void doRun();

    protected abstract void beforeExit() throws Exception;

    public void run() {
        try {
            this.doRun();
        }
        catch (Throwable throwable) {
            try {
                this.beforeExit();
            }
            catch (Throwable throwable2) {}
            this.closeCurrentFile();
            throw throwable;
        }
        try {
            this.beforeExit();
        }
        catch (Throwable throwable) {}
        this.closeCurrentFile();
    }

    protected void doFlush(ByteArray buffer) {
        if (this.out == null || this.needCreateNewFile()) {
            this.closeCurrentFile();
            this.out = this.createNewFile();
        }
        try {
            buffer.writeBytes(this.out, buffer.length());
        }
        catch (IOException iOException) {}
    }

    protected FileOutputStream createNewFile() {
        try {
            this.date = new Date(System.currentTimeMillis()).toString();
            String fileName = String.valueOf(this.filePrefix) + "_" + this.date + "_" + System.currentTimeMillis() + ".log";
            if (StringUtil.isNotEmpty(this.filePath) && StringUtil.isNotEmpty(fileName)) {
                File logPath = new File(this.filePath);
                if (!logPath.exists()) {
                    logPath.mkdirs();
                }
                this.logFile = new File(String.valueOf(this.filePath) + fileName);
                if (!this.logFile.exists()) {
                    this.logFile.createNewFile();
                }
                return new FileOutputStream(this.logFile, true);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    protected void closeCurrentFile() {
        if (this.out != null) {
            try {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    this.out = null;
                }
            }
            finally {
                this.out = null;
            }
        }
    }

    private boolean needCreateNewFile() {
        String value = new Date(System.currentTimeMillis()).toString();
        return !value.equals(this.date) || this.logFile == null || this.logFile.length() > 0x6400000L;
    }
}

