/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.core.swing;

import com.dahuatech.hutool.core.exceptions.UtilException;
import com.dahuatech.hutool.core.img.ImgUtil;
import com.dahuatech.hutool.core.swing.ScreenUtil;
import com.dahuatech.hutool.core.swing.clipboard.ClipboardUtil;
import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.File;

public class RobotUtil {
    private static final Robot robot;
    private static int delay;

    public static void setDelay(int delayMillis) {
        delay = delayMillis;
    }

    public static void mouseMove(int x, int y) {
        robot.mouseMove(x, y);
    }

    public static void click() {
        robot.mousePress(16);
        robot.mouseRelease(16);
        RobotUtil.delay();
    }

    public static void rightClick() {
        robot.mousePress(16);
        robot.mouseRelease(16);
        RobotUtil.delay();
    }

    public static void mouseWheel(int wheelAmt) {
        robot.mouseWheel(wheelAmt);
        RobotUtil.delay();
    }

    public static void keyClick(int ... keyCodes) {
        for (int keyCode : keyCodes) {
            robot.keyPress(keyCode);
            robot.keyRelease(keyCode);
        }
        RobotUtil.delay();
    }

    public static void keyPressString(String str) {
        ClipboardUtil.setStr(str);
        RobotUtil.keyPressWithCtrl(86);
        RobotUtil.delay();
    }

    public static void keyPressWithShift(int key) {
        robot.keyPress(16);
        robot.keyPress(key);
        robot.keyRelease(key);
        robot.keyRelease(16);
        RobotUtil.delay();
    }

    public static void keyPressWithCtrl(int key) {
        robot.keyPress(17);
        robot.keyPress(key);
        robot.keyRelease(key);
        robot.keyRelease(17);
        RobotUtil.delay();
    }

    public static void keyPressWithAlt(int key) {
        robot.keyPress(18);
        robot.keyPress(key);
        robot.keyRelease(key);
        robot.keyRelease(18);
        RobotUtil.delay();
    }

    public static BufferedImage captureScreen() {
        return RobotUtil.captureScreen(ScreenUtil.getRectangle());
    }

    public static File captureScreen(File outFile) {
        ImgUtil.write(RobotUtil.captureScreen(), outFile);
        return outFile;
    }

    public static BufferedImage captureScreen(Rectangle screenRect) {
        return robot.createScreenCapture(screenRect);
    }

    public static File captureScreen(Rectangle screenRect, File outFile) {
        ImgUtil.write(RobotUtil.captureScreen(screenRect), outFile);
        return outFile;
    }

    private static void delay() {
        if (delay > 0) {
            robot.delay(delay);
        }
    }

    static {
        try {
            robot = new Robot();
        }
        catch (AWTException e) {
            throw new UtilException(e);
        }
    }
}

