/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.core.lang;

import com.dahuatech.hutool.core.lang.Assert;
import com.dahuatech.hutool.core.util.StrUtil;
import java.util.Scanner;

public class Console {
    public static void log() {
        System.out.println();
    }

    public static void log(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            Console.log(e, e.getMessage(), new Object[0]);
        } else {
            Console.log("{}", obj);
        }
    }

    public static void print(Object obj) {
        Console.print("{}", obj);
    }

    public static void printProgress(char showChar, int len) {
        Console.print("{}{}", Character.valueOf('\r'), StrUtil.repeat(showChar, len));
    }

    public static void printProgress(char showChar, int totalLen, double rate) {
        Assert.isTrue(rate >= 0.0 && rate <= 1.0, "Rate must between 0 and 1 (both include)", new Object[0]);
        Console.printProgress(showChar, (int)((double)totalLen * rate));
    }

    public static void log(String template, Object ... values) {
        Console.log(null, template, values);
    }

    public static void print(String template, Object ... values) {
        System.out.print(StrUtil.format((CharSequence)template, values));
    }

    public static void log(Throwable t, String template, Object ... values) {
        System.out.println(StrUtil.format((CharSequence)template, values));
        if (null != t) {
            t.printStackTrace();
            System.out.flush();
        }
    }

    public static void error() {
        System.err.println();
    }

    public static void error(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            Console.error(e, e.getMessage(), new Object[0]);
        } else {
            Console.error("{}", obj);
        }
    }

    public static void error(String template, Object ... values) {
        Console.error(null, template, values);
    }

    public static void error(Throwable t, String template, Object ... values) {
        System.err.println(StrUtil.format((CharSequence)template, values));
        if (null != t) {
            t.printStackTrace(System.err);
            System.err.flush();
        }
    }

    public static Scanner scanner() {
        return new Scanner(System.in);
    }

    public static String input() {
        return Console.scanner().next();
    }
}

