/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.json.JSON;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONStringer;
import org.json.JSONTokener;

public class JSONObject {
    private static final Double NEGATIVE_ZERO = -0.0;
    @NonNull
    public static final Object NULL = new Object(){

        public boolean equals(Object o) {
            return o == this || o == null;
        }

        public int hashCode() {
            return Objects.hashCode(null);
        }

        public String toString() {
            return "null";
        }
    };
    private final LinkedHashMap<String, Object> nameValuePairs;

    public JSONObject() {
        this.nameValuePairs = new LinkedHashMap();
    }

    public JSONObject(@NonNull Map copyFrom) {
        this();
        Map contentsTyped = copyFrom;
        for (Map.Entry entry : contentsTyped.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null) {
                throw new NullPointerException("key == null");
            }
            this.nameValuePairs.put(key, JSONObject.wrap(entry.getValue()));
        }
    }

    public JSONObject(@NonNull JSONTokener readFrom) throws JSONException {
        Object object = readFrom.nextValue();
        if (!(object instanceof JSONObject)) {
            throw JSON.typeMismatch(object, "JSONObject");
        }
        this.nameValuePairs = ((JSONObject)object).nameValuePairs;
    }

    public JSONObject(@NonNull String json) throws JSONException {
        this(new JSONTokener(json));
    }

    public JSONObject(@NonNull JSONObject copyFrom, @NonNull String[] names) throws JSONException {
        this();
        for (String name : names) {
            Object value = copyFrom.opt(name);
            if (value == null) continue;
            this.nameValuePairs.put(name, value);
        }
    }

    public int length() {
        return this.nameValuePairs.size();
    }

    @NonNull
    public JSONObject put(@NonNull String name, boolean value) throws JSONException {
        this.nameValuePairs.put(this.checkName(name), value);
        return this;
    }

    @NonNull
    public JSONObject put(@NonNull String name, double value) throws JSONException {
        this.nameValuePairs.put(this.checkName(name), JSON.checkDouble(value));
        return this;
    }

    @NonNull
    public JSONObject put(@NonNull String name, int value) throws JSONException {
        this.nameValuePairs.put(this.checkName(name), value);
        return this;
    }

    @NonNull
    public JSONObject put(@NonNull String name, long value) throws JSONException {
        this.nameValuePairs.put(this.checkName(name), value);
        return this;
    }

    @NonNull
    public JSONObject put(@NonNull String name, @Nullable Object value) throws JSONException {
        if (value == null) {
            this.nameValuePairs.remove(name);
            return this;
        }
        if (value instanceof Number) {
            JSON.checkDouble(((Number)value).doubleValue());
        }
        this.nameValuePairs.put(this.checkName(name), value);
        return this;
    }

    @NonNull
    public JSONObject putOpt(@Nullable String name, @Nullable Object value) throws JSONException {
        if (name == null || value == null) {
            return this;
        }
        return this.put(name, value);
    }

    @NonNull
    public JSONObject accumulate(@NonNull String name, @Nullable Object value) throws JSONException {
        Object current = this.nameValuePairs.get(this.checkName(name));
        if (current == null) {
            return this.put(name, value);
        }
        if (current instanceof JSONArray) {
            JSONArray array = (JSONArray)current;
            array.checkedPut(value);
        } else {
            JSONArray array = new JSONArray();
            array.checkedPut(current);
            array.checkedPut(value);
            this.nameValuePairs.put(name, array);
        }
        return this;
    }

    public JSONObject append(String name, Object value) throws JSONException {
        JSONArray array;
        Object current = this.nameValuePairs.get(this.checkName(name));
        if (current instanceof JSONArray) {
            array = (JSONArray)current;
        } else if (current == null) {
            JSONArray newArray = new JSONArray();
            this.nameValuePairs.put(name, newArray);
            array = newArray;
        } else {
            throw new JSONException("Key " + name + " is not a JSONArray");
        }
        array.checkedPut(value);
        return this;
    }

    String checkName(String name) throws JSONException {
        if (name == null) {
            throw new JSONException("Names must be non-null");
        }
        return name;
    }

    @Nullable
    public Object remove(@Nullable String name) {
        return this.nameValuePairs.remove(name);
    }

    public boolean isNull(@Nullable String name) {
        Object value = this.nameValuePairs.get(name);
        return value == null || value == NULL;
    }

    public boolean has(@Nullable String name) {
        return this.nameValuePairs.containsKey(name);
    }

    @NonNull
    public Object get(@NonNull String name) throws JSONException {
        Object result = this.nameValuePairs.get(name);
        if (result == null) {
            throw new JSONException("No value for " + name);
        }
        return result;
    }

    @Nullable
    public Object opt(@Nullable String name) {
        return this.nameValuePairs.get(name);
    }

    public boolean getBoolean(@NonNull String name) throws JSONException {
        Object object = this.get(name);
        Boolean result = JSON.toBoolean(object);
        if (result == null) {
            throw JSON.typeMismatch(name, object, "boolean");
        }
        return result;
    }

    public boolean optBoolean(@Nullable String name) {
        return this.optBoolean(name, false);
    }

    public boolean optBoolean(@Nullable String name, boolean fallback) {
        Object object = this.opt(name);
        Boolean result = JSON.toBoolean(object);
        return result != null ? result : fallback;
    }

    public double getDouble(@NonNull String name) throws JSONException {
        Object object = this.get(name);
        Double result = JSON.toDouble(object);
        if (result == null) {
            throw JSON.typeMismatch(name, object, "double");
        }
        return result;
    }

    public double optDouble(@Nullable String name) {
        return this.optDouble(name, Double.NaN);
    }

    public double optDouble(@Nullable String name, double fallback) {
        Object object = this.opt(name);
        Double result = JSON.toDouble(object);
        return result != null ? result : fallback;
    }

    public int getInt(@NonNull String name) throws JSONException {
        Object object = this.get(name);
        Integer result = JSON.toInteger(object);
        if (result == null) {
            throw JSON.typeMismatch(name, object, "int");
        }
        return result;
    }

    public int optInt(@Nullable String name) {
        return this.optInt(name, 0);
    }

    public int optInt(@Nullable String name, int fallback) {
        Object object = this.opt(name);
        Integer result = JSON.toInteger(object);
        return result != null ? result : fallback;
    }

    public long getLong(@NonNull String name) throws JSONException {
        Object object = this.get(name);
        Long result = JSON.toLong(object);
        if (result == null) {
            throw JSON.typeMismatch(name, object, "long");
        }
        return result;
    }

    public long optLong(@Nullable String name) {
        return this.optLong(name, 0L);
    }

    public long optLong(@Nullable String name, long fallback) {
        Object object = this.opt(name);
        Long result = JSON.toLong(object);
        return result != null ? result : fallback;
    }

    @NonNull
    public String getString(@NonNull String name) throws JSONException {
        Object object = this.get(name);
        String result = JSON.toString(object);
        if (result == null) {
            throw JSON.typeMismatch(name, object, "String");
        }
        return result;
    }

    @NonNull
    public String optString(@Nullable String name) {
        return this.optString(name, "");
    }

    @NonNull
    public String optString(@Nullable String name, @NonNull String fallback) {
        Object object = this.opt(name);
        String result = JSON.toString(object);
        return result != null ? result : fallback;
    }

    @NonNull
    public JSONArray getJSONArray(@NonNull String name) throws JSONException {
        Object object = this.get(name);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw JSON.typeMismatch(name, object, "JSONArray");
    }

    @Nullable
    public JSONArray optJSONArray(@Nullable String name) {
        Object object = this.opt(name);
        return object instanceof JSONArray ? (JSONArray)object : null;
    }

    @NonNull
    public JSONObject getJSONObject(@NonNull String name) throws JSONException {
        Object object = this.get(name);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw JSON.typeMismatch(name, object, "JSONObject");
    }

    @Nullable
    public JSONObject optJSONObject(@Nullable String name) {
        Object object = this.opt(name);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    @Nullable
    public JSONArray toJSONArray(@Nullable JSONArray names) throws JSONException {
        JSONArray result = new JSONArray();
        if (names == null) {
            return null;
        }
        int length = names.length();
        if (length == 0) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            String name = JSON.toString(names.opt(i));
            result.put(this.opt(name));
        }
        return result;
    }

    @NonNull
    public Iterator<String> keys() {
        return this.nameValuePairs.keySet().iterator();
    }

    public Set<String> keySet() {
        return this.nameValuePairs.keySet();
    }

    @Nullable
    public JSONArray names() {
        return this.nameValuePairs.isEmpty() ? null : new JSONArray(new ArrayList<String>(this.nameValuePairs.keySet()));
    }

    @NonNull
    public String toString() {
        try {
            JSONStringer stringer = new JSONStringer();
            this.writeTo(stringer);
            return stringer.toString();
        }
        catch (JSONException e) {
            return null;
        }
    }

    @NonNull
    public String toString(int indentSpaces) throws JSONException {
        JSONStringer stringer = new JSONStringer(indentSpaces);
        this.writeTo(stringer);
        return stringer.toString();
    }

    void writeTo(JSONStringer stringer) throws JSONException {
        stringer.object();
        for (Map.Entry<String, Object> entry : this.nameValuePairs.entrySet()) {
            stringer.key(entry.getKey()).value(entry.getValue());
        }
        stringer.endObject();
    }

    @NonNull
    public static String numberToString(@NonNull Number number) throws JSONException {
        if (number == null) {
            throw new JSONException("Number must be non-null");
        }
        double doubleValue = number.doubleValue();
        JSON.checkDouble(doubleValue);
        if (number.equals(NEGATIVE_ZERO)) {
            return "-0";
        }
        long longValue = number.longValue();
        if (doubleValue == (double)longValue) {
            return Long.toString(longValue);
        }
        return number.toString();
    }

    @NonNull
    public static String quote(@Nullable String data) {
        if (data == null) {
            return "\"\"";
        }
        try {
            JSONStringer stringer = new JSONStringer();
            stringer.open(JSONStringer.Scope.NULL, "");
            stringer.value(data);
            stringer.close(JSONStringer.Scope.NULL, JSONStringer.Scope.NULL, "");
            return stringer.toString();
        }
        catch (JSONException e) {
            throw new AssertionError();
        }
    }

    @Nullable
    public static Object wrap(@Nullable Object o) {
        if (o == null) {
            return NULL;
        }
        if (o instanceof JSONArray || o instanceof JSONObject) {
            return o;
        }
        if (o.equals(NULL)) {
            return o;
        }
        try {
            if (o instanceof Collection) {
                return new JSONArray((Collection)o);
            }
            if (o.getClass().isArray()) {
                return new JSONArray(o);
            }
            if (o instanceof Map) {
                return new JSONObject((Map)o);
            }
            if (o instanceof Boolean || o instanceof Byte || o instanceof Character || o instanceof Double || o instanceof Float || o instanceof Integer || o instanceof Long || o instanceof Short || o instanceof String) {
                return o;
            }
            if (o.getClass().getPackage().getName().startsWith("java.")) {
                return o.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

