/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.replicator;

import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4Socket;
import com.couchbase.lite.internal.core.NativeContext;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.replicator.CBLCookieStore;
import com.couchbase.lite.internal.replicator.CBLTrustManager;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.StateMachine;
import com.couchbase.lite.internal.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Challenge;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public abstract class AbstractCBLWebSocket
extends C4Socket {
    private static final LogDomain TAG = LogDomain.NETWORK;
    private static final int MAX_AUTH_RETRIES = 3;
    public static final int DEFAULT_HEARTBEAT_SEC = 300;
    private static final String HEADER_AUTH = "Authorization";
    public static final String HEADER_COOKIES = "Cookies";
    @NonNull
    private static final NativeContext<KeyManager> KEY_MANAGERS = new NativeContext();
    private static final StateMachine.Builder<State> WS_STATE_BUILDER = new StateMachine.Builder<State>(State.class, State.INIT, State.FAILED).addTransition(State.INIT, State.CONNECTING, new State[0]).addTransition(State.CONNECTING, State.OPEN, new State[]{State.CLOSE_REQUESTED, State.CLOSING, State.CLOSED}).addTransition(State.OPEN, State.CLOSE_REQUESTED, new State[]{State.CLOSING, State.CLOSED}).addTransition(State.CLOSE_REQUESTED, State.CLOSING, new State[]{State.CLOSED}).addTransition(State.CLOSING, State.CLOSED, new State[0]);
    @NonNull
    private static final OkHttpClient BASE_HTTP_CLIENT = new OkHttpClient.Builder().connectTimeout(0L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).build();
    @NonNull
    private final URI uri;
    @NonNull
    private final OkHttpRemote okHttpRemote;
    @NonNull
    private final OkHttpClient okHttpSocketFactory;
    @Nullable
    private final Map<String, Object> options;
    @NonNull
    private final Fn.Consumer<List<Certificate>> serverCertsListener;
    @GuardedBy(value="getPeerLock()")
    @NonNull
    private final StateMachine<State> state = WS_STATE_BUILDER.build();
    @GuardedBy(value="getPeerLock()")
    @NonNull
    private final CBLCookieStore cookieStore;
    @GuardedBy(value="getPeerLock()")
    private WebSocket webSocket;

    public static int addKeyManager(@NonNull KeyManager keyManager) {
        int token = KEY_MANAGERS.reserveKey();
        KEY_MANAGERS.bind(token, keyManager);
        return token;
    }

    protected AbstractCBLWebSocket(long peer, @NonNull URI uri, @Nullable byte[] opts, @NonNull CBLCookieStore cookieStore, @NonNull Fn.Consumer<List<Certificate>> serverCertsListener) throws GeneralSecurityException {
        super(peer);
        this.uri = uri;
        this.options = opts == null ? null : Collections.unmodifiableMap(FLValue.fromData(opts).asDict());
        this.cookieStore = cookieStore;
        this.serverCertsListener = serverCertsListener;
        this.okHttpSocketFactory = this.setupOkHttpFactory();
        this.okHttpRemote = new OkHttpRemote();
    }

    @Override
    @NonNull
    public String toString() {
        return "CBLWebSocket{@" + super.toString() + ": " + this.uri + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Log.d(TAG, "%s#External told to close: %s", this, this.uri);
        Object object = this.getPeerLock();
        synchronized (object) {
            if (this.state.setState(State.CLOSE_REQUESTED)) {
                this.closeRequested(1001, "Closed by client");
                return;
            }
            if (this.state.setState(State.CLOSING)) {
                if (this.webSocket != null) {
                    this.closeWebSocket(1001, "Closed by client");
                }
                return;
            }
            this.state.setState(State.CLOSED);
        }
    }

    @NonNull
    @VisibleForTesting
    public final OkHttpClient getOkHttpSocketFactory() {
        return this.okHttpSocketFactory;
    }

    @Nullable
    @VisibleForTesting
    public Map<String, Object> getOptions() {
        return this.options;
    }

    protected abstract boolean handleClose(Throwable var1);

    protected abstract int handleCloseCause(Throwable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void openSocket() {
        Log.d(TAG, "%s#Core connect: %s", this, this.uri);
        Object object = this.getPeerLock();
        synchronized (object) {
            if (!this.state.setState(State.CONNECTING)) {
                return;
            }
            this.okHttpSocketFactory.newWebSocket(this.newRequest(), (WebSocketListener)this.okHttpRemote);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void send(@NonNull byte[] allocatedData) {
        Log.d(TAG, "%s#Core send: %d", this, allocatedData.length);
        Object object = this.getPeerLock();
        synchronized (object) {
            if (!this.state.assertState(new State[]{State.OPEN})) {
                return;
            }
            if (!this.webSocket.send(ByteString.of((byte[])allocatedData, (int)0, (int)allocatedData.length))) {
                Log.i(TAG, "CBLWebSocket failed to send data of length = " + allocatedData.length);
                return;
            }
            this.completedWrite(allocatedData.length);
        }
    }

    @Override
    protected final void completedReceive(long n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void requestClose(int code, String message) {
        Log.d(TAG, "%s#Core request close: %d", this, code);
        Object object = this.getPeerLock();
        synchronized (object) {
            if (!this.state.setState(State.CLOSING)) {
                return;
            }
            if (this.webSocket != null) {
                this.closeWebSocket(code, message);
                return;
            }
            this.state.setState(State.CLOSED);
            this.closeWithCode(code, message);
        }
    }

    @Override
    protected final void closeSocket() {
    }

    @GuardedBy(value="getPeerLock()")
    private void receivedHTTPResponse(@NonNull Response response) {
        Log.d(TAG, "CBLWebSocket received HTTP response %s", response);
        Headers hs = response.headers();
        if (hs == null || hs.size() <= 0) {
            return;
        }
        byte[] headersFleece = null;
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (int i = 0; i < hs.size(); ++i) {
            headers.put(hs.name(i), hs.value(i));
        }
        try (FLEncoder enc = FLEncoder.getManagedEncoder();){
            enc.write(headers);
            headersFleece = enc.finish();
        }
        catch (LiteCoreException e) {
            Log.w(TAG, "CBLWebSocket failed to encode response headers", e);
            Log.d(TAG, StringUtils.toString(headers));
        }
        this.gotHTTPResponse(response.code(), headersFleece);
    }

    @GuardedBy(value="getPeerLock()")
    private void closeWebSocket(int code, String message) {
        if (code > 100 && code < 600) {
            code = 1008;
        }
        if (!this.webSocket.close(code, message)) {
            Log.i(TAG, "CBLWebSocket failed to initiate a graceful shutdown of this web socket.");
        }
    }

    @GuardedBy(value="getPeerLock()")
    private void closeWithCode(int code, String reason) {
        Log.v(TAG, "WebSocket CLOSED with code: " + code + "(" + reason + ")");
        if (code == 1000) {
            this.closed(1, 0, null);
            return;
        }
        this.closed(6, code, reason);
    }

    @GuardedBy(value="getPeerLock()")
    private void closeWithError(@Nullable Throwable error) {
        int code;
        Log.i(TAG, "WebSocket CLOSED with error", error);
        if (error == null) {
            this.closed(6, 0, null);
            return;
        }
        if (this.handleClose(error)) {
            return;
        }
        int causeCode = this.getCodeForCause(error);
        int domain = 5;
        if (error instanceof NoRouteToHostException || error instanceof PortUnreachableException || error instanceof SocketTimeoutException) {
            code = 24;
        } else if (error instanceof SocketException || error instanceof EOFException) {
            code = 22;
        } else if (causeCode > 0) {
            code = causeCode;
        } else if (error instanceof UnknownHostException) {
            code = 2;
        } else if (error instanceof SSLHandshakeException) {
            code = 6;
        } else if (error instanceof SSLKeyException || error instanceof SSLPeerUnverifiedException) {
            code = 8;
        } else if (error instanceof SSLProtocolException) {
            domain = 6;
            code = 1002;
        } else if (error instanceof SSLException) {
            code = 16;
        } else {
            domain = 6;
            code = 1008;
        }
        this.closed(domain, code, error.toString());
    }

    private int getCodeForCause(Throwable error) {
        Throwable cause = error.getCause();
        if (cause == null) {
            return -1;
        }
        int code = this.handleCloseCause(cause);
        if (code > 0) {
            return code;
        }
        if (cause instanceof CertificateExpiredException) {
            return 14;
        }
        if (cause instanceof CertificateException) {
            return 8;
        }
        return 0;
    }

    @NonNull
    private OkHttpClient setupOkHttpFactory() throws GeneralSecurityException {
        OkHttpClient.Builder builder = BASE_HTTP_CLIENT.newBuilder();
        boolean acceptParentDomainCookies = false;
        if (this.options != null) {
            Object heartbeat = this.options.get("heartbeat");
            builder.pingInterval(heartbeat instanceof Number ? (Long)heartbeat : 300L, TimeUnit.SECONDS);
            Object acceptParentCookies = this.options.get("acceptParentDomainCookies");
            if (acceptParentCookies instanceof Boolean) {
                acceptParentDomainCookies = (Boolean)acceptParentCookies;
            }
        }
        this.setupBasicAuthenticator(builder);
        builder.cookieJar((CookieJar)new WebSocketCookieJar(acceptParentDomainCookies));
        this.setupSSLSocketFactory(builder);
        return builder.build();
    }

    @NonNull
    private Request newRequest() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.uri.toString());
        String host = this.uri.getHost();
        if (this.uri.getPort() >= 0) {
            host = host + ":" + this.uri.getPort();
        }
        builder.header("Host", host);
        if (this.options != null) {
            Object protocols;
            Object extraHeaders = this.options.get("headers");
            if (extraHeaders instanceof Map) {
                for (Map.Entry header : ((Map)extraHeaders).entrySet()) {
                    builder.header(header.getKey().toString(), header.getValue().toString());
                }
            }
            if ((protocols = this.options.get("WS-Protocols")) instanceof String) {
                builder.header("Sec-WebSocket-Protocol", (String)protocols);
            }
        }
        return builder.build();
    }

    private void setupBasicAuthenticator(@NonNull OkHttpClient.Builder builder) {
        if (this.options == null) {
            return;
        }
        Object obj = this.options.get("auth");
        if (!(obj instanceof Map)) {
            return;
        }
        Map auth = (Map)obj;
        Object authType = auth.get("type");
        if (!"Basic".equals(authType)) {
            return;
        }
        Object username = auth.get("username");
        if (!(username instanceof String)) {
            return;
        }
        Object password = auth.get("password");
        if (!(password instanceof String)) {
            return;
        }
        String credentials = Credentials.basic((String)((String)username), (String)((String)password));
        builder.authenticator((route, response) -> this.authenticate(response, credentials));
        builder.addInterceptor(chain -> {
            Request request = chain.request();
            try {
                return chain.proceed(chain.connection() != null ? request : request.newBuilder().header(HEADER_AUTH, credentials).method(request.method(), request.body()).build());
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Unexpected interceptor failure @" + Thread.currentThread() + ": " + request.method() + " \"" + request.body() + "\"", e);
            }
        });
    }

    private void setupSSLSocketFactory(@NonNull OkHttpClient.Builder builder) throws GeneralSecurityException {
        X509Certificate pinnedServerCert = null;
        boolean acceptOnlySelfSignedServerCert = false;
        KeyManager[] keyManagers = null;
        if (this.options != null) {
            KeyManager clientCertAuthKeyManager;
            Object opt = this.options.get("pinnedCert");
            if (opt instanceof byte[]) {
                try {
                    pinnedServerCert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream((byte[])opt));
                }
                catch (CertificateException e) {
                    Log.w(TAG, "Can't parse pinned certificate.  Ignored", e);
                }
            }
            if ((opt = this.options.get("onlySelfSignedServer")) instanceof Boolean) {
                acceptOnlySelfSignedServerCert = (Boolean)opt;
            }
            if ((clientCertAuthKeyManager = this.getAuthenticator()) != null) {
                keyManagers = new KeyManager[]{clientCertAuthKeyManager};
            }
        }
        CBLTrustManager trustManager = new CBLTrustManager(pinnedServerCert, acceptOnlySelfSignedServerCert, this.serverCertsListener);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, new TrustManager[]{trustManager}, null);
        builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManager);
        if (pinnedServerCert != null || acceptOnlySelfSignedServerCert) {
            builder.hostnameVerifier((s, sslSession) -> true);
        }
    }

    @Nullable
    private KeyManager getAuthenticator() {
        if (this.options == null) {
            return null;
        }
        Object opt = this.options.get("auth");
        if (!(opt instanceof Map)) {
            return null;
        }
        Map auth = (Map)opt;
        if (!"Client Cert".equals(auth.get("type"))) {
            return null;
        }
        KeyManager keyManager = null;
        Object certKey = auth.get("clientCertKey");
        if (certKey instanceof Long) {
            keyManager = KEY_MANAGERS.getObjFromContext((Long)certKey);
        }
        if (keyManager == null) {
            Log.i(TAG, "No key manager configured for client certificate authentication");
        }
        return keyManager;
    }

    @Nullable
    private Request authenticate(@NonNull Response resp, @NonNull String credentials) {
        Log.d(TAG, "CBLWebSocket.authenticate: %s", resp);
        if (this.responseCount(resp) >= 3) {
            return null;
        }
        List challenges = resp.challenges();
        Log.d(TAG, "CBLWebSocket challenges: %s", challenges);
        if (challenges == null) {
            return null;
        }
        for (Challenge challenge : challenges) {
            if (!"Basic".equalsIgnoreCase(challenge.scheme())) continue;
            return resp.request().newBuilder().header(HEADER_AUTH, credentials).build();
        }
        return null;
    }

    private int responseCount(Response response) {
        int result = 1;
        while ((response = response.priorResponse()) != null) {
            ++result;
        }
        return result;
    }

    private class WebSocketCookieJar
    implements CookieJar {
        private final boolean acceptParentDomain;

        WebSocketCookieJar(boolean acceptParentDomain) {
            this.acceptParentDomain = acceptParentDomain;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveFromResponse(@NonNull HttpUrl httpUrl, @NonNull List<Cookie> cookies) {
            ArrayList<String> cookieStrs = new ArrayList<String>(cookies.size());
            for (Cookie cookie : cookies) {
                cookieStrs.add(cookie.toString());
            }
            Object object = AbstractCBLWebSocket.this.getPeerLock();
            synchronized (object) {
                AbstractCBLWebSocket.this.cookieStore.setCookies(httpUrl.uri(), cookieStrs, this.acceptParentDomain);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public List<Cookie> loadForRequest(@NonNull HttpUrl url) {
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            Object object = AbstractCBLWebSocket.this.getPeerLock();
            synchronized (object) {
                String setCookies;
                String confCookies;
                if (!AbstractCBLWebSocket.this.state.assertState(new State[]{State.INIT, State.CONNECTING})) {
                    return cookies;
                }
                if (AbstractCBLWebSocket.this.options != null && (confCookies = (String)AbstractCBLWebSocket.this.options.get("cookies")) != null) {
                    cookies.addAll(CBLCookieStore.parseCookies(url, confCookies));
                }
                if ((setCookies = AbstractCBLWebSocket.this.cookieStore.getCookies(url.uri())) != null) {
                    cookies.addAll(CBLCookieStore.parseCookies(url, setCookies));
                }
                return cookies;
            }
        }
    }

    @ThreadSafe
    final class OkHttpRemote
    extends WebSocketListener {
        OkHttpRemote() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(@NonNull WebSocket webSocket, @NonNull Response response) {
            Log.d(TAG, "%s#OkHTTP open: %s", AbstractCBLWebSocket.this, response);
            Object object = AbstractCBLWebSocket.this.getPeerLock();
            synchronized (object) {
                if (!AbstractCBLWebSocket.this.state.setState(State.OPEN)) {
                    if (AbstractCBLWebSocket.this.state.assertState(new State[]{State.CLOSED, State.FAILED})) {
                        webSocket.cancel();
                    }
                    return;
                }
                AbstractCBLWebSocket.this.webSocket = webSocket;
                AbstractCBLWebSocket.this.receivedHTTPResponse(response);
                AbstractCBLWebSocket.this.opened();
            }
            Log.i(TAG, "WebSocket OPEN");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(@NonNull WebSocket webSocket, @NonNull String text) {
            Log.d(TAG, "%s#OkHTTP text data: %d", AbstractCBLWebSocket.this, text.length());
            Object object = AbstractCBLWebSocket.this.getPeerLock();
            synchronized (object) {
                if (!AbstractCBLWebSocket.this.state.assertState(new State[]{State.OPEN})) {
                    if (AbstractCBLWebSocket.this.state.assertState(new State[]{State.CLOSED, State.FAILED})) {
                        webSocket.cancel();
                    }
                    return;
                }
                AbstractCBLWebSocket.this.received(text.getBytes(StandardCharsets.UTF_8));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(@NonNull WebSocket webSocket, @NonNull ByteString bytes) {
            Log.d(TAG, "%s#OkHTTP byte data: %d", AbstractCBLWebSocket.this, bytes.size());
            Object object = AbstractCBLWebSocket.this.getPeerLock();
            synchronized (object) {
                if (!AbstractCBLWebSocket.this.state.assertState(new State[]{State.OPEN})) {
                    if (AbstractCBLWebSocket.this.state.assertState(new State[]{State.CLOSED, State.FAILED})) {
                        webSocket.cancel();
                    }
                    return;
                }
                AbstractCBLWebSocket.this.received(bytes.toByteArray());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClosing(@NonNull WebSocket webSocket, int code, @NonNull String reason) {
            Log.d(TAG, "%s#OkHTTP closing: %s", AbstractCBLWebSocket.this, reason);
            Object object = AbstractCBLWebSocket.this.getPeerLock();
            synchronized (object) {
                if (!AbstractCBLWebSocket.this.state.setState(State.CLOSE_REQUESTED)) {
                    if (AbstractCBLWebSocket.this.state.assertState(new State[]{State.CLOSED, State.FAILED})) {
                        webSocket.cancel();
                    }
                    return;
                }
                AbstractCBLWebSocket.this.closeRequested(code, reason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClosed(@NonNull WebSocket webSocket, int code, @NonNull String reason) {
            Log.d(TAG, "%s#OkHTTP closed: (%d) %s", AbstractCBLWebSocket.this, code, reason);
            Object object = AbstractCBLWebSocket.this.getPeerLock();
            synchronized (object) {
                if (!AbstractCBLWebSocket.this.state.setState(State.CLOSED)) {
                    return;
                }
                AbstractCBLWebSocket.this.closeWithCode(code, reason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(@NonNull WebSocket webSocket, @NonNull Throwable err, @Nullable Response response) {
            Log.d(TAG, "%s#OkHTTP failed: %s", err, AbstractCBLWebSocket.this, response);
            Object object = AbstractCBLWebSocket.this.getPeerLock();
            synchronized (object) {
                if (AbstractCBLWebSocket.this.state.assertState(new State[]{State.CLOSED, State.FAILED})) {
                    webSocket.cancel();
                    return;
                }
                AbstractCBLWebSocket.this.state.setState(State.FAILED);
                if (response == null) {
                    AbstractCBLWebSocket.this.closeWithError(err);
                    return;
                }
                AbstractCBLWebSocket.this.closeWithCode(response.code(), response.message());
            }
        }
    }

    private static enum State {
        INIT,
        CONNECTING,
        OPEN,
        CLOSE_REQUESTED,
        CLOSING,
        CLOSED,
        FAILED;

    }
}

