/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.replicator;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.StringUtils;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public abstract class AbstractCBLTrustManager
implements X509TrustManager {
    @Nullable
    private final X509Certificate pinnedServerCertificate;
    private final boolean acceptOnlySelfSignedServerCertificate;
    @NonNull
    private final Fn.Consumer<List<Certificate>> serverCertsListener;
    @NonNull
    private final AtomicReference<X509TrustManager> defaultTrustManager = new AtomicReference();

    public AbstractCBLTrustManager(@Nullable X509Certificate pinnedServerCert, boolean acceptOnlySelfSignedServerCertificate, @NonNull Fn.Consumer<List<Certificate>> serverCertsListener) {
        this.pinnedServerCertificate = pinnedServerCert;
        this.acceptOnlySelfSignedServerCertificate = acceptOnlySelfSignedServerCertificate;
        this.serverCertsListener = serverCertsListener;
    }

    @Override
    @NonNull
    public X509Certificate[] getAcceptedIssuers() {
        return this.useCBLTrustManagement() ? new X509Certificate[]{} : this.getDefaultTrustManager().getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(@Nullable X509Certificate[] chain, @Nullable String authType) {
        throw new UnsupportedOperationException("checkClientTrusted(X509Certificate[], String) not supported for client");
    }

    @Override
    public void checkServerTrusted(@Nullable X509Certificate[] chain, @Nullable String authType) throws CertificateException {
        List<X509Certificate> serverCerts = this.asList(chain);
        this.notifyListener(serverCerts);
        if (this.useCBLTrustManagement()) {
            this.cBLServerTrustCheck(serverCerts, authType);
            return;
        }
        Log.d(LogDomain.NETWORK, "Default trust check: %d, %s", chain == null ? 0 : chain.length, authType);
        this.getDefaultTrustManager().checkServerTrusted(chain, authType);
    }

    protected final void cBLServerTrustCheck(@Nullable List<X509Certificate> certs, @Nullable String authType) throws CertificateException {
        Log.d(LogDomain.NETWORK, "CBL trust check: %d, %s", certs == null ? 0 : certs.size(), authType);
        if (certs == null || certs.isEmpty()) {
            throw new IllegalArgumentException("No server certificates");
        }
        if (StringUtils.isEmpty(authType)) {
            throw new IllegalArgumentException("Invalid auth type: " + authType);
        }
        X509Certificate cert = certs.get(0);
        cert.checkValidity();
        if (this.pinnedServerCertificate == null) {
            if (certs.size() == 1 && this.isSelfSignedCertificate(cert)) {
                return;
            }
            throw new CertificateException("Server certificate is not self-signed");
        }
        int i = 0;
        while (true) {
            if (this.pinnedServerCertificate.equals(cert)) {
                return;
            }
            if (++i >= certs.size()) break;
            cert = certs.get(i);
            cert.checkValidity();
        }
        throw new CertificateException("The pinned certificate did not match any certificate in the server chain");
    }

    protected final void notifyListener(@NonNull List<X509Certificate> certs) {
        this.serverCertsListener.accept(Collections.unmodifiableList(certs));
    }

    protected final boolean useCBLTrustManagement() {
        return this.acceptOnlySelfSignedServerCertificate || this.pinnedServerCertificate != null;
    }

    @NonNull
    protected final List<X509Certificate> asList(@Nullable X509Certificate[] certs) {
        return certs == null ? Collections.emptyList() : Arrays.asList(certs);
    }

    @NonNull
    protected final X509TrustManager getDefaultTrustManager() {
        TrustManager[] trustManagers;
        X509TrustManager trustManager = this.defaultTrustManager.get();
        if (trustManager != null) {
            return trustManager;
        }
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot find the default trust manager", e);
        }
        for (TrustManager mgr : trustManagers) {
            if (!(mgr instanceof X509TrustManager)) continue;
            trustManager = (X509TrustManager)mgr;
            break;
        }
        if (trustManager == null) {
            throw new IllegalStateException("Cannot find an X509TrustManager");
        }
        this.defaultTrustManager.compareAndSet(null, trustManager);
        return this.defaultTrustManager.get();
    }

    private boolean isSelfSignedCertificate(@NonNull X509Certificate cert) {
        if (!cert.getSubjectDN().equals(cert.getIssuerDN())) {
            return false;
        }
        try {
            cert.verify(cert.getPublicKey());
            return true;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            return false;
        }
    }
}

