/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.internal.fleece.Encodable;
import com.couchbase.lite.internal.fleece.MContext;
import com.couchbase.lite.internal.fleece.MValue;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Objects;

public abstract class MCollection
implements Encodable {
    @Nullable
    private MContext context;
    @Nullable
    private MValue slot;
    @Nullable
    private MCollection parent;
    private boolean mutable;
    private boolean mutated;
    private boolean mutableChildren;

    protected MCollection() {
        this(MContext.NULL, true);
    }

    MCollection(@Nullable MContext context, boolean isMutable) {
        this.context = context;
        this.mutable = isMutable;
        this.mutableChildren = isMutable;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isMutated() {
        return this.mutated;
    }

    public boolean hasMutableChildren() {
        return this.mutableChildren;
    }

    @Nullable
    public MContext getContext() {
        return this.context;
    }

    public void initAsCopyOf(@NonNull MCollection original, boolean isMutable) {
        if (this.context != MContext.NULL) {
            throw new IllegalStateException("Current context is not null.");
        }
        this.context = Preconditions.assertNotNull(original, "original MCollection").getContext();
        this.mutable = isMutable;
        this.mutableChildren = isMutable;
    }

    protected void setSlot(@Nullable MValue newSlot, @Nullable MValue oldSlot) {
        if (Objects.equals(this.slot, oldSlot)) {
            this.slot = newSlot;
            if (newSlot == null) {
                this.parent = null;
            }
        }
    }

    protected void initInSlot(@NonNull MValue slot, @Nullable MCollection parent, boolean isMutable) {
        this.slot = Preconditions.assertNotNull(slot, "slot");
        if (this.context != MContext.NULL) {
            throw new IllegalStateException("Current context must be MContext.Null");
        }
        this.parent = parent;
        this.mutable = isMutable;
        this.mutableChildren = isMutable;
        this.mutated = this.slot.isMutated();
        if (this.slot.getValue() != null) {
            this.context = parent == null ? null : parent.getContext();
        }
    }

    protected void mutate() {
        if (!this.mutable) {
            throw new IllegalStateException("The collection object is not mutable.");
        }
        if (!this.mutated) {
            this.mutated = true;
            if (this.slot != null) {
                this.slot.mutate();
            }
            if (this.parent != null) {
                this.parent.mutate();
            }
        }
    }
}

