/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.utils.ClassUtils;

public abstract class FLSliceResult
extends C4NativePeer {
    @NonNull
    public static FLSliceResult getUnmanagedSliceResult() {
        return new UnmanagedFLSliceResult();
    }

    @NonNull
    public static FLSliceResult getUnmanagedSliceResult(long peer) {
        return new UnmanagedFLSliceResult(peer);
    }

    @NonNull
    public static FLSliceResult getManagedSliceResult() {
        return new ManagedFLSliceResult();
    }

    @NonNull
    public static FLSliceResult getManagedSliceResult(long peer) {
        return new ManagedFLSliceResult(peer);
    }

    private FLSliceResult() {
        this(FLSliceResult.init());
    }

    private FLSliceResult(long peer) {
        super(peer);
    }

    @Override
    @NonNull
    public String toString() {
        return "FLSliceResult{" + ClassUtils.objId(this) + "/" + super.toString() + "}";
    }

    @Override
    public abstract void close();

    public long getHandle() {
        return this.getPeer();
    }

    @NonNull
    public byte[] getBuf() {
        return FLSliceResult.getBuf(this.getPeer());
    }

    public long getSize() {
        return FLSliceResult.getSize(this.getPeer());
    }

    static native void free(long var0);

    private static native long init();

    @NonNull
    private static native byte[] getBuf(long var0);

    private static native long getSize(long var0);

    static final class ManagedFLSliceResult
    extends FLSliceResult {
        ManagedFLSliceResult() {
        }

        ManagedFLSliceResult(long peer) {
            super(peer);
        }

        @Override
        public void close() {
            this.closePeer(null);
        }

        protected void finalize() throws Throwable {
            try {
                this.closePeer(LogDomain.DATABASE);
            }
            finally {
                super.finalize();
            }
        }

        private void closePeer(@Nullable LogDomain domain) {
            this.releasePeer(domain, FLSliceResult::free);
        }
    }

    static final class UnmanagedFLSliceResult
    extends FLSliceResult {
        UnmanagedFLSliceResult() {
        }

        UnmanagedFLSliceResult(long peer) {
            super(peer);
        }

        @Override
        public void close() {
            this.releasePeer();
        }
    }
}

