/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.exec;

import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.exec.AbstractExecutionService;
import com.couchbase.lite.internal.exec.CBLExecutor;
import com.couchbase.lite.internal.exec.ExecutionService;
import com.couchbase.lite.internal.exec.InstrumentedTask;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class ConcurrentExecutor
implements ExecutionService.CloseableExecutor {
    private static final LogDomain DOMAIN = LogDomain.DATABASE;
    @NonNull
    private final ThreadPoolExecutor executor;
    @GuardedBy(value="this")
    @Nullable
    private CountDownLatch stopLatch;
    @GuardedBy(value="this")
    private int running;

    ConcurrentExecutor(@NonNull ThreadPoolExecutor executor) {
        Preconditions.assertNotNull(executor, "executor");
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NonNull Runnable task) {
        Preconditions.assertNotNull(task, "task");
        ConcurrentExecutor concurrentExecutor = this;
        synchronized (concurrentExecutor) {
            if (this.stopLatch != null) {
                throw new ExecutionService.CloseableExecutor.ExecutorClosedException("Executor has been stopped");
            }
            this.executeTask(new InstrumentedTask(task, this::finishTask));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stop(long timeout, @NonNull TimeUnit unit) {
        CountDownLatch latch;
        Preconditions.assertNotNegative(timeout, "timeout");
        Preconditions.assertNotNull(unit, "time unit");
        ConcurrentExecutor concurrentExecutor = this;
        synchronized (concurrentExecutor) {
            if (this.stopLatch == null) {
                this.stopLatch = new CountDownLatch(1);
            }
            if (this.running <= 0) {
                return true;
            }
            latch = this.stopLatch;
        }
        try {
            return latch.await(timeout, unit);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    @NonNull
    public String toString() {
        return "CBL concurrent executor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpState(@Nullable InstrumentedTask rejected) {
        int nowRunning;
        ConcurrentExecutor concurrentExecutor = this;
        synchronized (concurrentExecutor) {
            nowRunning = this.running;
        }
        Log.w(DOMAIN, "==== Concurrent Executor (" + nowRunning + ")");
        if (rejected != null) {
            Log.w(DOMAIN, "== Rejected task: " + rejected, rejected.origin);
        }
        if (this.executor instanceof CBLExecutor) {
            ((CBLExecutor)this.executor).dumpState();
        }
        AbstractExecutionService.dumpThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishTask() {
        CountDownLatch latch;
        ConcurrentExecutor concurrentExecutor = this;
        synchronized (concurrentExecutor) {
            if (--this.running > 0) {
                return;
            }
            latch = this.stopLatch;
        }
        if (latch != null) {
            latch.countDown();
        }
    }

    @GuardedBy(value="this")
    private void executeTask(@NonNull InstrumentedTask newTask) {
        try {
            this.executor.execute(newTask);
            ++this.running;
        }
        catch (RuntimeException e) {
            Log.w(LogDomain.DATABASE, "!!! Catastrophic executor failure (Concurrent Executor)", e);
            if (!AbstractExecutionService.throttled()) {
                this.dumpState(newTask);
            }
            throw e;
        }
    }
}

