/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.exec;

import android.support.annotation.NonNull;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.exec.InstrumentedTask;
import com.couchbase.lite.internal.support.Log;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class CBLExecutor
extends ThreadPoolExecutor {
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int POOL_SIZE = Math.max(4, CPU_COUNT - 1);
    @NonNull
    private final String name;
    private long n;
    private int qSizeMax;
    private float qSizeMean;
    private float qSizeVariance;
    private float m2;

    public CBLExecutor(@NonNull String name) {
        this(name, POOL_SIZE, POOL_SIZE, new LinkedBlockingQueue<Runnable>());
    }

    public CBLExecutor(final @NonNull String name, int min, int max, @NonNull BlockingQueue<Runnable> workQueue) {
        super(min, max, 30L, TimeUnit.SECONDS, workQueue, new ThreadFactory(){
            private final String threadName;
            private final AtomicInteger threadId;
            {
                this.threadName = name + " #";
                this.threadId = new AtomicInteger(0);
            }

            @Override
            @NonNull
            public Thread newThread(@NonNull Runnable r) {
                Thread thread = new Thread(r, this.threadName + this.threadId.incrementAndGet());
                thread.setUncaughtExceptionHandler((t, e) -> Log.e(LogDomain.DATABASE, "Uncaught exception on thread " + thread.getName(), e));
                return thread;
            }
        });
        this.allowCoreThreadTimeOut(true);
        this.name = name;
    }

    @Override
    public void execute(@NonNull Runnable task) {
        super.execute(task);
        this.computeQueueStats();
    }

    @Override
    @NonNull
    public String toString() {
        return "CBLExecutor(" + this.name + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpState() {
        double stdDev;
        float mean;
        int max;
        String string = this.name;
        synchronized (string) {
            max = this.qSizeMax;
            mean = this.qSizeMean;
            stdDev = Math.sqrt(this.qSizeVariance);
        }
        Log.w(LogDomain.DATABASE, "==== CBL Executor \"%s\" (%s)", this.name, this.isShutdown() ? "x" : (this.isTerminated() ? "o" : (this.isTerminating() ? "-" : "+")));
        Log.w(LogDomain.DATABASE, "== Tasks: %d, %d", this.getTaskCount(), this.getCompletedTaskCount());
        Log.w(LogDomain.DATABASE, "== Pool: %d, %d, %d", this.getPoolSize(), this.getLargestPoolSize(), this.getMaximumPoolSize());
        ArrayList<Runnable> waiting = new ArrayList<Runnable>(this.getQueue());
        if (waiting.isEmpty()) {
            Log.w(LogDomain.DATABASE, "== Queue is empty");
            return;
        }
        Log.w(LogDomain.DATABASE, "== Queue: %d, %d, %.2f, %.4f", waiting.size(), max, Float.valueOf(mean), stdDev);
        int n = 0;
        for (Runnable r : waiting) {
            Exception orig = !(r instanceof InstrumentedTask) ? null : ((InstrumentedTask)r).origin;
            Log.w(LogDomain.DATABASE, "@" + n++ + ": " + r, orig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeQueueStats() {
        int qSize = this.getQueue().size();
        String string = this.name;
        synchronized (string) {
            if (this.qSizeMax < qSize) {
                this.qSizeMax = qSize;
            }
            ++this.n;
            float delta = (float)qSize - this.qSizeMean;
            this.qSizeMean += delta / (float)this.n;
            this.m2 += delta * ((float)qSize - this.qSizeMean);
            if (this.n > 2L) {
                this.qSizeVariance = this.m2 / (float)(this.n - 1L);
            }
        }
    }
}

