/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4Document;
import com.couchbase.lite.internal.core.C4NativePeer;

@VisibleForTesting
public class C4DocEnumerator
extends C4NativePeer {
    C4DocEnumerator(long db, long since, int flags) throws LiteCoreException {
        this(C4DocEnumerator.enumerateChanges(db, since, flags));
    }

    C4DocEnumerator(long db, int flags) throws LiteCoreException {
        this(C4DocEnumerator.enumerateAllDocs(db, flags));
    }

    private C4DocEnumerator(long peer) {
        super(peer);
    }

    @NonNull
    public C4Document getDocument() throws LiteCoreException {
        return new C4Document(C4DocEnumerator.getDocument(this.getPeer()));
    }

    public boolean next() throws LiteCoreException {
        return C4DocEnumerator.next(this.getPeer());
    }

    @Override
    @CallSuper
    public void close() {
        this.closePeer(null);
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.DATABASE);
        }
        finally {
            super.finalize();
        }
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, C4DocEnumerator::free);
    }

    private static native long enumerateAllDocs(long var0, int var2) throws LiteCoreException;

    private static native long enumerateChanges(long var0, long var2, int var4) throws LiteCoreException;

    private static native boolean next(long var0) throws LiteCoreException;

    private static native long getDocument(long var0) throws LiteCoreException;

    private static native void free(long var0);
}

