/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.exec.AbstractExecutionService;
import com.couchbase.lite.internal.exec.CBLExecutor;
import com.couchbase.lite.internal.exec.ExecutionService;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class JavaExecutionService
extends AbstractExecutionService {
    private final Executor defaultExecutor = Executors.newSingleThreadExecutor();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public JavaExecutionService() {
        this(new CBLExecutor("CBL worker"));
    }

    @VisibleForTesting
    public JavaExecutionService(@NonNull ThreadPoolExecutor executor) {
        super(executor);
    }

    @Override
    @NonNull
    public Executor getDefaultExecutor() {
        return this.defaultExecutor;
    }

    @Override
    @NonNull
    public ExecutionService.Cancellable postDelayedOnExecutor(long delayMs, @NonNull Executor executor, @NonNull Runnable task) {
        Preconditions.assertNotNull(executor, "executor");
        Preconditions.assertNotNull(task, "task");
        Runnable delayedTask = () -> {
            block3: {
                try {
                    executor.execute(task);
                }
                catch (ExecutionService.CloseableExecutor.ExecutorClosedException e) {
                    Log.w(LogDomain.DATABASE, "Scheduled on closed executor: " + task + ", " + executor);
                }
                catch (RejectedExecutionException e) {
                    if (JavaExecutionService.throttled()) break block3;
                    Log.w(LogDomain.DATABASE, "!!! Execution rejected after delay: " + delayMs, e);
                    JavaExecutionService.dumpThreads();
                }
            }
        };
        ScheduledFuture<?> future = this.scheduler.schedule(delayedTask, delayMs, TimeUnit.MILLISECONDS);
        return new CancellableTask(future);
    }

    private static final class CancellableTask
    implements ExecutionService.Cancellable {
        private final Future<?> future;

        private CancellableTask(@NonNull Future<?> future) {
            Preconditions.assertNotNull(future, "future");
            this.future = future;
        }

        @Override
        public void cancel() {
            this.future.cancel(false);
        }
    }
}

