/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.JavaExecutionService;
import com.couchbase.lite.internal.NativeLibrary;
import com.couchbase.lite.internal.core.C4Base;
import com.couchbase.lite.internal.exec.ExecutionService;
import com.couchbase.lite.internal.fleece.MValue;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.FileUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class CouchbaseLiteInternal {
    public static final String SCRATCH_DIR_NAME = "CouchbaseLiteTemp";
    private static final String ERRORS_PROPERTIES_PATH = "/errors.properties";
    private static final AtomicReference<ExecutionService> EXECUTION_SERVICE = new AtomicReference();
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static final Object LOCK = new Object();
    private static volatile boolean debugging;
    private static volatile File rootDir;
    private static volatile File scratchDir;

    private CouchbaseLiteInternal() {
    }

    public static void init(@NonNull MValue.Delegate mValueDelegate, boolean debug, @NonNull File rootDir, @NonNull File scratchDir) {
        if (INITIALIZED.getAndSet(true)) {
            return;
        }
        debugging = debug;
        Preconditions.assertNotNull(mValueDelegate, "mValueDelegate");
        CouchbaseLiteInternal.rootDir = Preconditions.assertNotNull(FileUtils.verifyDir(rootDir), "rootDir");
        CouchbaseLiteInternal.scratchDir = Preconditions.assertNotNull(FileUtils.verifyDir(scratchDir), "scratchDir");
        NativeLibrary.load(scratchDir);
        C4Base.debug(debugging);
        Log.initLogging(CouchbaseLiteInternal.loadErrorMessages());
        CouchbaseLiteInternal.setC4TmpDirPath(scratchDir);
        MValue.registerDelegate(mValueDelegate);
    }

    public static boolean debugging() {
        return debugging;
    }

    @NonNull
    public static ExecutionService getExecutionService() {
        ExecutionService executionService = EXECUTION_SERVICE.get();
        if (executionService != null) {
            return executionService;
        }
        EXECUTION_SERVICE.compareAndSet(null, new JavaExecutionService());
        return EXECUTION_SERVICE.get();
    }

    public static void requireInit(String message) {
        if (!INITIALIZED.get()) {
            throw new IllegalStateException(message + ".  Did you forget to call CouchbaseLite.init()?");
        }
    }

    @NonNull
    public static File getRootDir() {
        CouchbaseLiteInternal.requireInit("Can't create DB path");
        return rootDir;
    }

    @NonNull
    public static String getRootDirPath() {
        return rootDir.getAbsolutePath();
    }

    @NonNull
    public static File getScratchDir() {
        CouchbaseLiteInternal.requireInit("Can't create Scratch path");
        return scratchDir;
    }

    @NonNull
    public static String getScratchDirPath() {
        return scratchDir.getAbsolutePath();
    }

    @VisibleForTesting
    public static void reset(boolean state) {
        INITIALIZED.set(state);
    }

    @VisibleForTesting
    @NonNull
    public static Map<String, String> loadErrorMessages() {
        Properties errors = new Properties();
        try (InputStream is = CouchbaseLiteInternal.class.getResourceAsStream(ERRORS_PROPERTIES_PATH);){
            errors.load(is);
        }
        catch (IOException e) {
            Log.i(LogDomain.DATABASE, "Failed to load error messages!", e);
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setC4TmpDirPath(@NonNull File scratchDir) {
        try {
            Object object = LOCK;
            synchronized (object) {
                C4Base.setTempDir(scratchDir.getAbsolutePath());
            }
        }
        catch (LiteCoreException e) {
            Log.w(LogDomain.DATABASE, "Failed to set c4TmpDir", e);
        }
    }
}

