/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.Endpoint;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.ReplicatorConfiguration;
import com.couchbase.lite.URLEndpoint;
import com.couchbase.lite.internal.core.C4Socket;
import com.couchbase.lite.internal.replicator.CBLCookieStore;
import com.couchbase.lite.internal.replicator.CBLWebSocket;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.util.List;

public abstract class AbstractSocketFactory {
    @NonNull
    private final CBLCookieStore cookieStore;
    @NonNull
    private final Fn.Consumer<List<Certificate>> serverCertsListener;
    @NonNull
    protected final Endpoint endpoint;
    @GuardedBy(value="endpoint")
    @Nullable
    private Fn.Consumer<C4Socket> listener;

    public AbstractSocketFactory(@NonNull ReplicatorConfiguration config, @NonNull CBLCookieStore cookieStore, @NonNull Fn.Consumer<List<Certificate>> serverCertsListener) {
        this.endpoint = config.getTarget();
        this.cookieStore = cookieStore;
        this.serverCertsListener = serverCertsListener;
    }

    @Nullable
    public final C4Socket createSocket(long peer, @NonNull String scheme, @NonNull String host, int port, @NonNull String path, @NonNull byte[] opts) {
        C4Socket socket;
        C4Socket c4Socket = socket = this.endpoint instanceof URLEndpoint ? this.createCBLWebSocket(peer, scheme, host, port, path, opts) : this.createPlatformSocket(peer);
        if (socket == null) {
            throw new IllegalStateException("Can't create endpoint: " + this.endpoint);
        }
        Fn.Consumer<C4Socket> listener = this.getListener();
        if (listener != null) {
            listener.accept(socket);
        }
        return socket;
    }

    @NonNull
    public String toString() {
        return "SocketFactory{endpoint=" + this.endpoint + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void setListener(@Nullable Fn.Consumer<C4Socket> listener) {
        Endpoint endpoint = this.endpoint;
        synchronized (endpoint) {
            this.listener = listener;
        }
    }

    @Nullable
    protected abstract C4Socket createPlatformSocket(long var1);

    @Nullable
    private C4Socket createCBLWebSocket(long peer, @NonNull String scheme, @NonNull String host, int port, @NonNull String path, @NonNull byte[] opts) {
        URI uri;
        try {
            uri = new URI(this.translateScheme(scheme), null, host, port, path, null, null);
        }
        catch (URISyntaxException e) {
            Log.w(LogDomain.NETWORK, "Bad URI for socket: %s//%s:%d/%s", e, scheme, host, port, path);
            return null;
        }
        try {
            return new CBLWebSocket(peer, uri, opts, this.cookieStore, this.serverCertsListener);
        }
        catch (Exception e) {
            Log.w(LogDomain.NETWORK, "Failed to instantiate CBLWebSocket", e);
            return null;
        }
    }

    @NonNull
    private String translateScheme(@NonNull String scheme) {
        Preconditions.assertNotNull(scheme, "scheme");
        if ("blip".equalsIgnoreCase(scheme)) {
            return "ws";
        }
        if ("blips".equalsIgnoreCase(scheme)) {
            return "wss";
        }
        return scheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Fn.Consumer<C4Socket> getListener() {
        Endpoint endpoint = this.endpoint;
        synchronized (endpoint) {
            return this.listener;
        }
    }
}

