/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.internal.BaseAuthenticator;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Locale;
import java.util.Map;

public final class SessionAuthenticator
extends BaseAuthenticator {
    private static final String DEFAULT_SYNC_GATEWAY_SESSION_ID_NAME = "SyncGatewaySession";
    @NonNull
    private final String sessionID;
    @NonNull
    private final String cookieName;

    public SessionAuthenticator(@NonNull String sessionID) {
        this(sessionID, DEFAULT_SYNC_GATEWAY_SESSION_ID_NAME);
    }

    public SessionAuthenticator(@NonNull String sessionID, @Nullable String cookieName) {
        Preconditions.assertNotNull(sessionID, "sessionID");
        this.sessionID = sessionID;
        this.cookieName = cookieName != null ? cookieName : DEFAULT_SYNC_GATEWAY_SESSION_ID_NAME;
    }

    @NonNull
    public String getSessionID() {
        return this.sessionID;
    }

    @Nullable
    public String getCookieName() {
        return this.cookieName;
    }

    @Override
    protected void authenticate(@NonNull Map<String, Object> options) {
        StringBuffer cookieStr;
        String current = (String)options.get("cookies");
        StringBuffer stringBuffer = cookieStr = current != null ? new StringBuffer(current) : new StringBuffer();
        if (cookieStr.length() > 0) {
            cookieStr.append("; ");
        }
        cookieStr.append(String.format(Locale.ENGLISH, "%s=%s", this.cookieName, this.sessionID));
        options.put("cookies", cookieStr.toString());
    }
}

