/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.DocumentFlag;
import java.util.EnumSet;

public final class ReplicatedDocument {
    @NonNull
    private final String id;
    @NonNull
    private final EnumSet<DocumentFlag> flags;
    @Nullable
    private final CouchbaseLiteException error;

    ReplicatedDocument(@NonNull String id, int flags, @Nullable CouchbaseLiteException error, boolean ignore) {
        this.id = id;
        this.error = error;
        this.flags = EnumSet.noneOf(DocumentFlag.class);
        if ((flags & 1) == 1) {
            this.flags.add(DocumentFlag.DELETED);
        }
        if ((flags & 0x80) == 128) {
            this.flags.add(DocumentFlag.ACCESS_REMOVED);
        }
    }

    @NonNull
    public String getID() {
        return this.id;
    }

    @NonNull
    public EnumSet<DocumentFlag> getFlags() {
        return this.flags;
    }

    @Nullable
    public CouchbaseLiteException getError() {
        return this.error;
    }

    @NonNull
    public String toString() {
        return "ReplicatedDocument{@" + this.id + ", " + this.error + "}";
    }
}

