/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Expression;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Arrays;

public final class FullTextFunction {
    private FullTextFunction() {
    }

    @NonNull
    public static Expression match(@NonNull String indexName, @NonNull String text) {
        Preconditions.assertNotNull(indexName, "indexName");
        return new Expression.FunctionExpression("MATCH()", Arrays.asList(Expression.string(indexName), Expression.string(text)));
    }

    @NonNull
    public static Expression rank(@NonNull String indexName) {
        Preconditions.assertNotNull(indexName, "indexName");
        return new Expression.FunctionExpression("RANK()", Arrays.asList(Expression.string(indexName)));
    }
}

