/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.Array;
import com.couchbase.lite.BaseDatabase;
import com.couchbase.lite.Blob;
import com.couchbase.lite.CBLConverter;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.DictionaryInterface;
import com.couchbase.lite.Fleece;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.MutableDictionary;
import com.couchbase.lite.internal.DbContext;
import com.couchbase.lite.internal.fleece.FLEncodable;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.JSONEncoder;
import com.couchbase.lite.internal.fleece.MCollection;
import com.couchbase.lite.internal.fleece.MContext;
import com.couchbase.lite.internal.fleece.MDict;
import com.couchbase.lite.internal.fleece.MValue;
import com.couchbase.lite.internal.utils.JSONUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Dictionary
implements DictionaryInterface,
FLEncodable,
Iterable<String> {
    @NonNull
    protected final Object lock;
    @NonNull
    protected final MDict internalDict;

    Dictionary() {
        this(new MDict());
    }

    Dictionary(@NonNull MValue mv, @Nullable MCollection parent) {
        this(new MDict(mv, parent));
    }

    Dictionary(@NonNull MDict mDict, boolean isMutable) {
        this(new MDict(mDict, isMutable));
    }

    private Dictionary(@NonNull MDict internalDict) {
        this.internalDict = internalDict;
        this.lock = this.getDbLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableDictionary toMutable() {
        Object object = this.lock;
        synchronized (object) {
            return new MutableDictionary(this.internalDict, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count() {
        Object object = this.lock;
        synchronized (object) {
            return (int)this.internalDict.count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public List<String> getKeys() {
        Object object = this.lock;
        synchronized (object) {
            return this.internalDict.getKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object getValue(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            return this.internalDict.get(key).asNative(this.internalDict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getString(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            Object obj = this.internalDict.get(key).asNative(this.internalDict);
            return obj instanceof String ? (String)obj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Number getNumber(@NonNull String key) {
        Preconditions.assertNotEmpty(key, "key");
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asNumber(this.internalDict.get(key).asNative(this.internalDict));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asInteger(this.internalDict.get(key), this.internalDict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asLong(this.internalDict.get(key), this.internalDict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asFloat(this.internalDict.get(key), this.internalDict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asDouble(this.internalDict.get(key), this.internalDict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asBoolean(this.internalDict.get(key).asNative(this.internalDict));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Blob getBlob(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            Object obj = this.internalDict.get(key).asNative(this.internalDict);
            return obj instanceof Blob ? (Blob)obj : null;
        }
    }

    @Override
    @Nullable
    public Date getDate(@NonNull String key) {
        return JSONUtils.toDate(this.getString(Preconditions.assertNotNull(key, "key")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Array getArray(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            Object obj = this.internalDict.get(key).asNative(this.internalDict);
            return obj instanceof Array ? (Array)obj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Dictionary getDictionary(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            Object obj = this.internalDict.get(key).asNative(this.internalDict);
            return obj instanceof Dictionary ? (Dictionary)obj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object object = this.lock;
        synchronized (object) {
            for (String key : this.internalDict) {
                result.put(key, Fleece.toObject(this.internalDict.get(key).asNative(this.internalDict)));
            }
        }
        return result;
    }

    @Override
    @NonNull
    public String toJSON() {
        JSONEncoder encoder = new JSONEncoder();
        try {
            this.internalDict.encodeTo(encoder);
            String string = encoder.finishJSON();
            encoder.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    encoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (LiteCoreException e) {
                throw new IllegalStateException("Failed marshalling Dictionary to JSON", CouchbaseLiteException.convertException(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            return !this.internalDict.get(key).isEmpty();
        }
    }

    @Override
    public void encodeTo(@NonNull FLEncoder enc) {
        this.internalDict.encodeTo(enc);
    }

    @Override
    @NonNull
    public Iterator<String> iterator() {
        return this.getKeys().iterator();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dictionary)) {
            return false;
        }
        Dictionary m = (Dictionary)o;
        if (m.count() != this.count()) {
            return false;
        }
        for (String key : this) {
            Object value = this.getValue(key);
            if (!(value != null ? !value.equals(m.getValue(key)) : m.getValue(key) != null || !m.contains(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        for (String key : this) {
            Object value = this.getValue(key);
            h += key.hashCode() ^ (value == null ? 0 : value.hashCode());
        }
        return h;
    }

    @NonNull
    public String toString() {
        StringBuilder buf = new StringBuilder("Dictionary{(").append(this.internalDict.isMutable() ? (char)'+' : '.').append(this.internalDict.isMutated() ? (char)'!' : '.').append(')');
        boolean first = true;
        for (String key : this.getKeys()) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(key).append("=>").append(this.getValue(key));
        }
        return buf.append('}').toString();
    }

    protected boolean isEmpty() {
        return this.count() == 0;
    }

    @NonNull
    MCollection toMCollection() {
        return this.internalDict;
    }

    @NonNull
    private Object getDbLock() {
        BaseDatabase db;
        MContext context = this.internalDict.getContext();
        if (context instanceof DbContext && (db = ((DbContext)context).getDatabase()) != null) {
            return db.getDbLock();
        }
        return new Object();
    }
}

