/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.ChangeListener;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import java.util.concurrent.Executor;

class ChangeListenerToken<T>
implements ListenerToken {
    @NonNull
    private final ChangeListener<T> listener;
    @Nullable
    private final Executor executor;
    @Nullable
    private Object key;

    ChangeListenerToken(@Nullable Executor executor, @NonNull ChangeListener<T> listener) {
        this.executor = executor;
        this.listener = listener;
    }

    @Nullable
    public Object getKey() {
        return this.key;
    }

    public void setKey(@Nullable Object key) {
        this.key = key;
    }

    void postChange(@Nullable T change) {
        Executor exec = this.executor != null ? this.executor : CouchbaseLiteInternal.getExecutionService().getDefaultExecutor();
        exec.execute(() -> this.listener.changed(change));
    }
}

