/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.ConflictResolver;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Document;
import com.couchbase.lite.DocumentFlag;
import com.couchbase.lite.DocumentReplication;
import com.couchbase.lite.DocumentReplicationListener;
import com.couchbase.lite.DocumentReplicationListenerToken;
import com.couchbase.lite.Endpoint;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.ReplicatedDocument;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.Replicator;
import com.couchbase.lite.ReplicatorActivityLevel;
import com.couchbase.lite.ReplicatorChange;
import com.couchbase.lite.ReplicatorChangeListener;
import com.couchbase.lite.ReplicatorChangeListenerToken;
import com.couchbase.lite.ReplicatorConfiguration;
import com.couchbase.lite.ReplicatorListener;
import com.couchbase.lite.ReplicatorProgress;
import com.couchbase.lite.ReplicatorStatus;
import com.couchbase.lite.ReplicatorType;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.ImmutableReplicatorConfiguration;
import com.couchbase.lite.internal.SocketFactory;
import com.couchbase.lite.internal.core.BaseReplicator;
import com.couchbase.lite.internal.core.C4DocumentEnded;
import com.couchbase.lite.internal.core.C4Error;
import com.couchbase.lite.internal.core.C4ReplicationFilter;
import com.couchbase.lite.internal.core.C4Replicator;
import com.couchbase.lite.internal.core.C4ReplicatorListener;
import com.couchbase.lite.internal.core.C4ReplicatorMode;
import com.couchbase.lite.internal.core.C4ReplicatorStatus;
import com.couchbase.lite.internal.exec.ExecutionService;
import com.couchbase.lite.internal.fleece.FLDict;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.replicator.CBLCookieStore;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import com.couchbase.lite.internal.utils.StringUtils;
import java.net.URI;
import java.security.cert.Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractReplicator
extends BaseReplicator {
    private static final LogDomain DOMAIN = LogDomain.REPLICATOR;
    @NonNull
    private final ImmutableReplicatorConfiguration config;
    private final Executor dispatcher = CouchbaseLiteInternal.getExecutionService().getSerialExecutor();
    @GuardedBy(value="getReplicatorLock()")
    private final Set<ReplicatorChangeListenerToken> changeListeners = new HashSet<ReplicatorChangeListenerToken>();
    @GuardedBy(value="getReplicatorLock()")
    private final Set<DocumentReplicationListenerToken> docEndedListeners = new HashSet<DocumentReplicationListenerToken>();
    @NonNull
    private final Set<Fn.Consumer<CouchbaseLiteException>> pendingResolutions = new HashSet<Fn.Consumer<CouchbaseLiteException>>();
    @NonNull
    private final Deque<C4ReplicatorStatus> pendingStatusNotifications = new LinkedList<C4ReplicatorStatus>();
    @NonNull
    private final C4ReplicatorListener c4ReplListener;
    @NonNull
    private final SocketFactory socketFactory;
    private final AtomicReference<List<Certificate>> serverCertificates = new AtomicReference();
    @NonNull
    @GuardedBy(value="getReplicatorLock()")
    private ReplicatorStatus status = new ReplicatorStatus(ReplicatorActivityLevel.STOPPED, new ReplicatorProgress(0L, 0L), null);
    @GuardedBy(value="getReplicatorLock()")
    private C4ReplicationFilter c4ReplPushFilter;
    @GuardedBy(value="getReplicatorLock()")
    private C4ReplicationFilter c4ReplPullFilter;
    @GuardedBy(value="getReplicatorLock()")
    @Nullable
    private CouchbaseLiteException lastError;
    private volatile String desc;

    static boolean isStopped(@NonNull C4ReplicatorStatus c4Status) {
        return c4Status.getActivityLevel() == 0;
    }

    static boolean isOffline(@NonNull C4ReplicatorStatus c4Status) {
        return c4Status.getActivityLevel() == 1;
    }

    protected AbstractReplicator(@NonNull ReplicatorConfiguration config) {
        Preconditions.assertNotNull(config, "config");
        this.config = new ImmutableReplicatorConfiguration(config);
        this.socketFactory = new SocketFactory(config, new ReplicatorCookieStore(this.getDatabase()), this::setServerCertificates);
        this.c4ReplListener = new ReplicatorListener(this.dispatcher);
    }

    public void start() {
        this.start(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean resetCheckpoint) {
        Log.i(DOMAIN, "Replicator is starting");
        this.getDatabase().addActiveReplicator(this);
        C4Replicator repl = this.getOrCreateC4Replicator();
        Object object = this.getReplicatorLock();
        synchronized (object) {
            repl.start(resetCheckpoint);
            C4ReplicatorStatus status = repl.getStatus();
            if (status == null) {
                status = new C4ReplicatorStatus(0, 1, 10);
            }
            status = this.updateStatus(status);
            this.c4ReplListener.statusChanged(repl, status, this);
        }
    }

    public void stop() {
        C4Replicator c4repl = this.getC4Replicator();
        Log.i(DOMAIN, "%s: Replicator is stopping (%s)", this, c4repl);
        if (c4repl == null) {
            return;
        }
        c4repl.stop();
    }

    @NonNull
    public ReplicatorConfiguration getConfig() {
        return new ReplicatorConfiguration(this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ReplicatorStatus getStatus() {
        Object object = this.getReplicatorLock();
        synchronized (object) {
            return new ReplicatorStatus(this.status);
        }
    }

    @Nullable
    public List<Certificate> getServerCertificates() {
        List<Certificate> serverCerts = this.serverCertificates.get();
        return serverCerts == null || serverCerts.isEmpty() ? null : new ArrayList<Certificate>(serverCerts);
    }

    @NonNull
    public Set<String> getPendingDocumentIds() throws CouchbaseLiteException {
        Set<String> pending;
        if (this.config.getType().equals((Object)ReplicatorType.PULL)) {
            throw new CouchbaseLiteException("PullOnlyPendingDocIDs", "CouchbaseLite", 19);
        }
        try {
            pending = this.getOrCreateC4Replicator().getPendingDocIDs();
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e, "Failed fetching pending documentIds");
        }
        if (pending == null) {
            throw new IllegalStateException("Pending doc ids is unexpectedly null");
        }
        return Collections.unmodifiableSet(pending);
    }

    public boolean isDocumentPending(@NonNull String docId) throws CouchbaseLiteException {
        Preconditions.assertNotNull(docId, "document ID");
        if (this.config.getType().equals((Object)ReplicatorType.PULL)) {
            throw new CouchbaseLiteException("PullOnlyPendingDocIDs", "CouchbaseLite", 19);
        }
        try {
            return this.getOrCreateC4Replicator().isDocumentPending(docId);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e, "Failed getting document pending status");
        }
    }

    @NonNull
    public ListenerToken addChangeListener(@NonNull ReplicatorChangeListener listener) {
        Preconditions.assertNotNull(listener, "listener");
        return this.addChangeListener(null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ListenerToken addChangeListener(@Nullable Executor executor, @NonNull ReplicatorChangeListener listener) {
        Preconditions.assertNotNull(listener, "listener");
        Object object = this.getReplicatorLock();
        synchronized (object) {
            ReplicatorChangeListenerToken token = new ReplicatorChangeListenerToken(executor, listener);
            this.changeListeners.add(token);
            this.setProgressLevel();
            return token;
        }
    }

    @NonNull
    public ListenerToken addDocumentReplicationListener(@NonNull DocumentReplicationListener listener) {
        Preconditions.assertNotNull(listener, "listener");
        return this.addDocumentReplicationListener(null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ListenerToken addDocumentReplicationListener(@Nullable Executor executor, @NonNull DocumentReplicationListener listener) {
        Preconditions.assertNotNull(listener, "listener");
        Object object = this.getReplicatorLock();
        synchronized (object) {
            DocumentReplicationListenerToken token = new DocumentReplicationListenerToken(executor, listener);
            this.docEndedListeners.add(token);
            this.setProgressLevel();
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(@NonNull ListenerToken token) {
        Preconditions.assertNotNull(token, "token");
        Object object = this.getReplicatorLock();
        synchronized (object) {
            if (token instanceof ReplicatorChangeListenerToken) {
                this.changeListeners.remove(token);
            } else if (token instanceof DocumentReplicationListenerToken) {
                this.docEndedListeners.remove(token);
            } else {
                throw new IllegalArgumentException("unexpected token: " + token);
            }
            this.setProgressLevel();
        }
    }

    @NonNull
    public String toString() {
        if (this.desc == null) {
            this.desc = this.description();
        }
        return this.desc;
    }

    @GuardedBy(value="getDbLock()")
    @NonNull
    protected abstract C4Replicator createReplicatorForTarget(@NonNull Endpoint var1) throws LiteCoreException;

    protected abstract void handleOffline(@NonNull ReplicatorActivityLevel var1, boolean var2);

    @GuardedBy(value="getDbLock()")
    @NonNull
    protected final C4Replicator getRemoteC4Replicator(@NonNull URI remoteUri) throws LiteCoreException {
        int p = remoteUri.getPort();
        int port = Math.max(0, p);
        Deque<String> splitPath = this.splitPath(remoteUri.getPath());
        String dbName = splitPath.size() <= 0 ? "" : splitPath.removeLast();
        String path = "/" + StringUtils.join("/", splitPath);
        boolean continuous = this.config.isContinuous();
        return this.getDatabase().createRemoteReplicator((Replicator)this, remoteUri.getScheme(), remoteUri.getHost(), port, path, dbName, this.makeMode(this.config.isPush(), continuous), this.makeMode(this.config.isPull(), continuous), this.getFleeceOptions(), this.c4ReplListener, this.c4ReplPushFilter, this.c4ReplPullFilter, this.socketFactory, 1);
    }

    @GuardedBy(value="getDbLock()")
    @NonNull
    protected final C4Replicator getLocalC4Replicator(@NonNull Database otherDb) throws LiteCoreException {
        boolean continuous = this.config.isContinuous();
        return this.getDatabase().createLocalReplicator((Replicator)this, otherDb, this.makeMode(this.config.isPush(), continuous), this.makeMode(this.config.isPull(), continuous), this.getFleeceOptions(), this.c4ReplListener, this.c4ReplPushFilter, this.c4ReplPullFilter);
    }

    @GuardedBy(value="getDbLock()")
    @NonNull
    protected final C4Replicator getMessageC4Replicator(int framing) throws LiteCoreException {
        boolean continuous = this.config.isContinuous();
        return this.getDatabase().createRemoteReplicator((Replicator)this, "x-msg-endpt", null, 0, null, null, this.makeMode(this.config.isPush(), continuous), this.makeMode(this.config.isPull(), continuous), this.getFleeceOptions(), this.c4ReplListener, this.c4ReplPushFilter, this.c4ReplPullFilter, this.socketFactory, framing);
    }

    @Nullable
    @VisibleForTesting
    CouchbaseLiteException getLastError() {
        return this.lastError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    ReplicatorActivityLevel getState() {
        Object object = this.getReplicatorLock();
        synchronized (object) {
            return this.status.getActivityLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void c4StatusChanged(@NonNull C4ReplicatorStatus c4Status) {
        ArrayList<ReplicatorChangeListenerToken> tokens;
        ReplicatorChange change;
        Iterator iterator = this.getReplicatorLock();
        synchronized (iterator) {
            Log.i(DOMAIN, "status changed: (%d, %d) @%s for %s", this.pendingResolutions.size(), this.pendingStatusNotifications.size(), c4Status, this);
            if (this.config.isContinuous()) {
                this.handleOffline(this.status.getActivityLevel(), !AbstractReplicator.isOffline(c4Status));
            }
            if (!this.pendingResolutions.isEmpty()) {
                this.pendingStatusNotifications.add(c4Status);
            }
            if (!this.pendingStatusNotifications.isEmpty()) {
                return;
            }
            this.updateStatus(c4Status);
            change = new ReplicatorChange((Replicator)this, this.getStatus());
            tokens = new ArrayList<ReplicatorChangeListenerToken>(this.changeListeners);
        }
        if (AbstractReplicator.isStopped(c4Status)) {
            this.getDatabase().removeActiveReplicator(this);
        }
        for (ReplicatorChangeListenerToken token : tokens) {
            token.notify(change);
        }
    }

    void documentEnded(boolean pushing, C4DocumentEnded ... docEnds) {
        ArrayList<ReplicatedDocument> unconflictedDocs = new ArrayList<ReplicatedDocument>();
        for (C4DocumentEnded docEnd : docEnds) {
            String docId = docEnd.getDocID();
            C4Error c4Error = docEnd.getC4Error();
            CouchbaseLiteException error = null;
            if (c4Error != null && c4Error.getCode() != 0) {
                if (!pushing && docEnd.isConflicted()) {
                    this.queueConflictResolution(docId, docEnd.getFlags());
                    continue;
                }
                error = CouchbaseLiteException.convertC4Error(c4Error);
            }
            unconflictedDocs.add(new ReplicatedDocument(docId, docEnd.getFlags(), error, docEnd.errorIsTransient()));
        }
        if (!unconflictedDocs.isEmpty()) {
            this.notifyDocumentEnded(pushing, unconflictedDocs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConflictResolved(Fn.Consumer<CouchbaseLiteException> task, String docId, int flags, CouchbaseLiteException err) {
        Log.i(DOMAIN, "Conflict resolved: %s", err, docId);
        ArrayList<C4ReplicatorStatus> pendingNotifications = null;
        Iterator iterator = this.getReplicatorLock();
        synchronized (iterator) {
            this.pendingResolutions.remove(task);
            if (this.pendingResolutions.isEmpty()) {
                pendingNotifications = new ArrayList<C4ReplicatorStatus>(this.pendingStatusNotifications);
                this.pendingStatusNotifications.clear();
            }
        }
        this.notifyDocumentEnded(false, Arrays.asList(new ReplicatedDocument(docId, flags, err, false)));
        if (pendingNotifications != null && !pendingNotifications.isEmpty()) {
            for (C4ReplicatorStatus status : pendingNotifications) {
                this.dispatcher.execute(() -> this.c4StatusChanged(status));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyDocumentEnded(boolean pushing, List<ReplicatedDocument> docs) {
        ArrayList<DocumentReplicationListenerToken> tokens;
        DocumentReplication update = new DocumentReplication((Replicator)this, pushing, docs);
        Iterator iterator = this.getReplicatorLock();
        synchronized (iterator) {
            tokens = new ArrayList<DocumentReplicationListenerToken>(this.docEndedListeners);
        }
        for (DocumentReplicationListenerToken token : tokens) {
            token.notify(update);
        }
        Log.i(DOMAIN, "notifyDocumentEnded: %s" + update);
    }

    @NonNull
    @VisibleForTesting
    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getListenerCount() {
        Object object = this.getReplicatorLock();
        synchronized (object) {
            return this.changeListeners.size() + this.docEndedListeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private C4Replicator getOrCreateC4Replicator() {
        Object object = this.config.getDatabase().getDbLock();
        synchronized (object) {
            C4Replicator c4Repl = this.getC4Replicator();
            if (c4Repl != null) {
                c4Repl.setOptions(this.getFleeceOptions());
                Object object2 = this.getReplicatorLock();
                synchronized (object2) {
                    this.setProgressLevel();
                }
                return c4Repl;
            }
            this.setupFilters();
            try {
                c4Repl = this.createReplicatorForTarget(this.config.getTarget());
                Object object3 = this.getReplicatorLock();
                synchronized (object3) {
                    this.setC4Replicator(c4Repl);
                    this.setProgressLevel();
                }
                return c4Repl;
            }
            catch (LiteCoreException e) {
                throw new IllegalStateException("Could not create replicator", CouchbaseLiteException.convertException(e));
            }
        }
    }

    @NonNull
    @GuardedBy(value="getReplicatorLock()")
    private C4ReplicatorStatus updateStatus(@NonNull C4ReplicatorStatus c4Status) {
        ReplicatorStatus oldStatus = this.status;
        this.status = new ReplicatorStatus(c4Status);
        CouchbaseLiteException err = this.status.getError();
        if (c4Status.getErrorCode() != 0) {
            this.lastError = err;
        }
        Log.i(DOMAIN, "State changed %s => %s(%d/%d): %s for %s", new Object[]{oldStatus.getActivityLevel(), this.status.getActivityLevel(), c4Status.getProgressUnitsCompleted(), c4Status.getProgressUnitsTotal(), err, this});
        return c4Status.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueConflictResolution(final @NonNull String docId, final int flags) {
        Log.i(DOMAIN, "%s: pulled conflicting version of '%s'", this, docId);
        ExecutionService.CloseableExecutor executor = CouchbaseLiteInternal.getExecutionService().getConcurrentExecutor();
        Database db = this.getDatabase();
        ConflictResolver resolver = this.config.getConflictResolver();
        Fn.Consumer<CouchbaseLiteException> task = new Fn.Consumer<CouchbaseLiteException>(){

            @Override
            public void accept(CouchbaseLiteException err) {
                AbstractReplicator.this.onConflictResolved(this, docId, flags, err);
            }
        };
        Object object = this.getReplicatorLock();
        synchronized (object) {
            executor.execute(() -> db.resolveReplicationConflict(resolver, docId, task));
            this.pendingResolutions.add(task);
        }
    }

    @Nullable
    private byte[] getFleeceOptions() {
        Map<String, Object> options = this.config.getConnectionOptions();
        byte[] optionsFleece = null;
        if (!options.isEmpty()) {
            try (FLEncoder enc = FLEncoder.getManagedEncoder();){
                enc.write(options);
                optionsFleece = enc.finish();
            }
            catch (LiteCoreException e) {
                Log.w(DOMAIN, "Failed encoding replicator options", e);
            }
        }
        return optionsFleece;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupFilters() {
        Object object = this.getReplicatorLock();
        synchronized (object) {
            if (this.config.getPushFilter() != null) {
                this.c4ReplPushFilter = (docID, revId, flags, dict, isPush, repl) -> repl.filterDocument(docID, revId, this.getDocumentFlags(flags), dict, isPush);
            }
            if (this.config.getPullFilter() != null) {
                this.c4ReplPullFilter = (docID, revId, flags, dict, isPush, repl) -> repl.filterDocument(docID, revId, this.getDocumentFlags(flags), dict, isPush);
            }
        }
    }

    private int makeMode(boolean active, boolean continuous) {
        C4ReplicatorMode mode = !active ? C4ReplicatorMode.C4_DISABLED : (continuous ? C4ReplicatorMode.C4_CONTINUOUS : C4ReplicatorMode.C4_ONE_SHOT);
        return mode.getVal();
    }

    @NonNull
    private EnumSet<DocumentFlag> getDocumentFlags(int flags) {
        EnumSet<DocumentFlag> documentFlags = EnumSet.noneOf(DocumentFlag.class);
        if ((flags & 1) == 1) {
            documentFlags.add(DocumentFlag.DELETED);
        }
        if ((flags & 0x80) == 128) {
            documentFlags.add(DocumentFlag.ACCESS_REMOVED);
        }
        return documentFlags;
    }

    private boolean filterDocument(@NonNull String docId, String revId, @NonNull EnumSet<DocumentFlag> flags, long dict, boolean isPush) {
        ReplicationFilter filter = isPush ? this.config.getPushFilter() : this.config.getPullFilter();
        return filter != null && filter.filtered(new Document(this.getDatabase(), docId, revId, new FLDict(dict)), flags);
    }

    @GuardedBy(value="getReplicatorLock()")
    private void setProgressLevel() {
        C4Replicator c4Repl = this.getC4Replicator();
        if (c4Repl == null) {
            return;
        }
        try {
            c4Repl.setProgressLevel(this.docEndedListeners.isEmpty() ? 0 : 1);
        }
        catch (LiteCoreException e) {
            Log.w(LogDomain.REPLICATOR, "failed setting progress level");
        }
    }

    @NonNull
    private Database getDatabase() {
        return this.config.getDatabase();
    }

    private void setServerCertificates(List<Certificate> certificates) {
        this.serverCertificates.set(certificates);
    }

    @NonNull
    private String description() {
        return this.baseDesc() + "," + this.getDatabase() + " => " + this.config.getTarget() + "}";
    }

    @NonNull
    private String simpleDesc() {
        return this.baseDesc() + "}";
    }

    @NonNull
    private String baseDesc() {
        return "Replicator{" + ClassUtils.objId(this) + "(" + (this.config.isPull() ? "<" : "") + (this.config.isContinuous() ? "*" : "-") + (this.config.isPush() ? ">" : "") + ")";
    }

    @NonNull
    private Deque<String> splitPath(@NonNull String fullPath) {
        ArrayDeque<String> path = new ArrayDeque<String>();
        for (String element : fullPath.split("/")) {
            if (element.length() <= 0) continue;
            path.addLast(element);
        }
        return path;
    }

    static class ReplicatorCookieStore
    implements CBLCookieStore {
        @NonNull
        private final Database db;

        ReplicatorCookieStore(@NonNull Database db) {
            this.db = db;
        }

        @Override
        public void setCookies(@NonNull URI uri, @NonNull List<String> cookies, boolean acceptParentDomain) {
            this.db.setCookies(uri, cookies, acceptParentDomain);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public String getCookies(@NonNull URI uri) {
            Object object = this.db.getDbLock();
            synchronized (object) {
                return !this.db.isOpen() ? null : this.db.getCookies(uri);
            }
        }
    }
}

