/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.CouchbaseLiteException;

public abstract class AbstractIndex {
    @NonNull
    private final QueryLanguage queryLanguage;
    @NonNull
    private final IndexType indexType;

    protected AbstractIndex(@NonNull IndexType indexType, @NonNull QueryLanguage queryLanguage) {
        this.indexType = indexType;
        this.queryLanguage = queryLanguage;
    }

    @NonNull
    abstract String getIndexSpec() throws CouchbaseLiteException;

    @NonNull
    final QueryLanguage getQueryLanguage() {
        return this.queryLanguage;
    }

    @NonNull
    final IndexType getIndexType() {
        return this.indexType;
    }

    @Nullable
    String getLanguage() {
        return null;
    }

    boolean isIgnoringAccents() {
        return false;
    }

    @NonNull
    public String toString() {
        return "IndexDescriptor(" + (Object)((Object)this.getQueryLanguage()) + ", " + (Object)((Object)this.indexType) + "}";
    }

    public static enum IndexType {
        VALUE(0),
        FULL_TEXT(1),
        PREDICTIVE(3);

        private final int value;

        private IndexType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum QueryLanguage {
        JSON(0),
        N1QL(1);

        private final int value;

        private QueryLanguage(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

