/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.grpc.CallCredentials;
import com.couchbase.client.core.deps.io.netty.handler.ssl.SslContextBuilder;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.Validators;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import reactor.util.annotation.Nullable;

public class CertificateAuthenticator
implements Authenticator {
    private final PrivateKey key;
    private final String keyPassword;
    private final List<X509Certificate> keyCertChain;
    private final Supplier<KeyManagerFactory> keyManagerFactory;

    public static CertificateAuthenticator fromKeyStore(Path keyStorePath, String keyStorePassword, Optional<String> keyStoreType) {
        CertificateAuthenticator certificateAuthenticator;
        block8: {
            Validators.notNull(keyStorePath, "KeyStorePath");
            Validators.notNull(keyStoreType, "KeyStoreType");
            InputStream keyStoreInputStream = Files.newInputStream(keyStorePath, new OpenOption[0]);
            try {
                KeyStore store = KeyStore.getInstance(keyStoreType.orElse(KeyStore.getDefaultType()));
                store.load(keyStoreInputStream, keyStorePassword != null ? keyStorePassword.toCharArray() : null);
                certificateAuthenticator = CertificateAuthenticator.fromKeyStore(store, keyStorePassword);
                if (keyStoreInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (keyStoreInputStream != null) {
                        try {
                            keyStoreInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw InvalidArgumentException.fromMessage("Could not initialize KeyStore from Path", ex);
                }
            }
            keyStoreInputStream.close();
        }
        return certificateAuthenticator;
    }

    public static CertificateAuthenticator fromKeyStore(KeyStore keyStore, String keyStorePassword) {
        Validators.notNull(keyStore, "KeyStore");
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, keyStorePassword != null ? keyStorePassword.toCharArray() : null);
            return CertificateAuthenticator.fromKeyManagerFactory(() -> kmf);
        }
        catch (Exception ex) {
            throw InvalidArgumentException.fromMessage("Could not initialize KeyManagerFactory with KeyStore", ex);
        }
    }

    public static CertificateAuthenticator fromKeyManagerFactory(Supplier<KeyManagerFactory> keyManagerFactory) {
        Validators.notNull(keyManagerFactory, "KeyManagerFactory");
        return new CertificateAuthenticator(null, null, null, keyManagerFactory);
    }

    public static CertificateAuthenticator fromKey(PrivateKey key, String keyPassword, List<X509Certificate> keyCertChain) {
        Validators.notNull(key, "PrivateKey");
        Validators.notNullOrEmpty(keyCertChain, "KeyCertChain");
        return new CertificateAuthenticator(key, keyPassword, keyCertChain, null);
    }

    private CertificateAuthenticator(PrivateKey key, String keyPassword, List<X509Certificate> keyCertChain, Supplier<KeyManagerFactory> keyManagerFactory) {
        this.key = key;
        this.keyPassword = keyPassword;
        this.keyCertChain = keyCertChain;
        this.keyManagerFactory = keyManagerFactory;
        if (key != null && keyManagerFactory != null) {
            throw InvalidArgumentException.fromMessage("Either a key certificate or a key manager factory can be provided, but not both!");
        }
    }

    @Override
    @Nullable
    @Stability.Internal
    public CallCredentials protostellarCallCredentials() {
        throw new FeatureNotAvailableException("CertificateAuthenticator is not supported with couchbase2");
    }

    @Override
    public void applyTlsProperties(SslContextBuilder context) {
        if (this.keyManagerFactory != null) {
            context.keyManager(this.keyManagerFactory.get());
        } else if (this.key != null) {
            context.keyManager(this.key, this.keyPassword, this.keyCertChain.toArray(new X509Certificate[0]));
        }
    }

    @Override
    public boolean supportsNonTls() {
        return false;
    }

    public String toString() {
        return "CertificateAuthenticator{key=" + this.key + ", keyCertChain=" + this.keyCertChain + ", keyManagerFactory=" + this.keyManagerFactory + '}';
    }
}

