/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.retry.reactor;

import com.couchbase.client.core.retry.reactor.BackoffDelay;
import com.couchbase.client.core.retry.reactor.RandomJitter;
import java.time.Duration;
import java.util.function.Function;

public interface Jitter
extends Function<BackoffDelay, Duration> {
    public static final Jitter NO_JITTER = new Jitter(){

        @Override
        public Duration apply(BackoffDelay delay) {
            return delay.delay();
        }

        public String toString() {
            return "Jitter{NONE}";
        }
    };
    public static final Jitter RANDOM_JITTER = new RandomJitter(0.5);

    public static Jitter noJitter() {
        return NO_JITTER;
    }

    public static Jitter random() {
        return RANDOM_JITTER;
    }

    public static Jitter random(double randomFactor) {
        return new RandomJitter(randomFactor);
    }
}

