/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.http;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import reactor.util.annotation.Nullable;

@Stability.Internal
public interface CoreCommonOptions {
    public static final CoreCommonOptions DEFAULT = new CoreCommonOptions(){

        @Override
        public Optional<Duration> timeout() {
            return Optional.empty();
        }

        @Override
        public Optional<RetryStrategy> retryStrategy() {
            return Optional.empty();
        }

        @Override
        public Optional<RequestSpan> parentSpan() {
            return Optional.empty();
        }
    };

    public Optional<Duration> timeout();

    public Optional<RetryStrategy> retryStrategy();

    public Optional<RequestSpan> parentSpan();

    @Nullable
    default public Map<String, Object> clientContext() {
        return null;
    }

    public static CoreCommonOptions of(final @Nullable Duration timeout, final @Nullable RetryStrategy retryStrategy, final @Nullable RequestSpan parentSpan) {
        if (timeout == null && retryStrategy == null && parentSpan == null) {
            return DEFAULT;
        }
        return new CoreCommonOptions(){

            @Override
            public Optional<Duration> timeout() {
                return Optional.ofNullable(timeout);
            }

            @Override
            public Optional<RetryStrategy> retryStrategy() {
                return Optional.ofNullable(retryStrategy);
            }

            @Override
            public Optional<RequestSpan> parentSpan() {
                return Optional.ofNullable(parentSpan);
            }
        };
    }

    public static CoreCommonOptions ofOptional(final Optional<Duration> timeout, final Optional<RetryStrategy> retryStrategy, final Optional<RequestSpan> parentSpan) {
        if (!(timeout.isPresent() || retryStrategy.isPresent() || parentSpan.isPresent())) {
            return DEFAULT;
        }
        return new CoreCommonOptions(){

            @Override
            public Optional<Duration> timeout() {
                return timeout;
            }

            @Override
            public Optional<RetryStrategy> retryStrategy() {
                return retryStrategy;
            }

            @Override
            public Optional<RequestSpan> parentSpan() {
                return parentSpan;
            }
        };
    }

    default public CoreCommonOptions withParentSpan(RequestSpan span) {
        return CoreCommonOptions.of(this.timeout().orElse(null), this.retryStrategy().orElse(null), span);
    }
}

