/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.message;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageDirection;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.interceptor.MessageConstructionInterceptor;
import com.consol.citrus.variable.dictionary.DataDictionary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;

public class HttpMessageContentBuilder
extends AbstractMessageContentBuilder {
    private final HttpMessage template;
    private final AbstractMessageContentBuilder delegate;

    public HttpMessageContentBuilder(HttpMessage httpMessage, AbstractMessageContentBuilder delegate) {
        this.template = httpMessage;
        this.delegate = delegate;
    }

    public Message buildMessageContent(TestContext context, String messageType) {
        return this.buildMessageContent(context, messageType, MessageDirection.UNBOUND);
    }

    public Message buildMessageContent(TestContext context, String messageType, MessageDirection direction) {
        HttpMessage message = new HttpMessage((Message)this.template);
        this.delegate.getMessageHeaders().putAll(this.template.getHeaders());
        Message constructed = this.delegate.buildMessageContent(context, messageType, direction);
        message.setName(this.delegate.getMessageName());
        message.setPayload(constructed.getPayload());
        message.setCookies(this.constructCookies(context));
        this.replaceHeaders(constructed, (Message)message);
        return message;
    }

    private void replaceHeaders(Message from, Message to) {
        to.getHeaders().clear();
        to.getHeaders().putAll(from.getHeaders());
    }

    private Cookie[] constructCookies(TestContext context) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (Cookie cookie : this.template.getCookies()) {
            Cookie constructed = new Cookie(cookie.getName(), cookie.getValue());
            if (cookie.getValue() != null) {
                constructed.setValue(context.replaceDynamicContentInString(cookie.getValue()));
            }
            if (cookie.getComment() != null) {
                constructed.setComment(context.replaceDynamicContentInString(cookie.getComment()));
            }
            if (cookie.getPath() != null) {
                constructed.setPath(context.replaceDynamicContentInString(cookie.getPath()));
            }
            if (cookie.getDomain() != null) {
                constructed.setDomain(context.replaceDynamicContentInString(cookie.getDomain()));
            }
            constructed.setMaxAge(cookie.getMaxAge());
            constructed.setVersion(cookie.getVersion());
            constructed.setHttpOnly(cookie.isHttpOnly());
            constructed.setSecure(cookie.getSecure());
            cookies.add(constructed);
        }
        return cookies.toArray(new Cookie[0]);
    }

    public DataDictionary getDataDictionary() {
        return this.delegate.getDataDictionary();
    }

    public List<MessageConstructionInterceptor> getMessageInterceptors() {
        return this.delegate.getMessageInterceptors();
    }

    public void setMessageInterceptors(List<MessageConstructionInterceptor> messageInterceptors) {
        this.delegate.setMessageInterceptors(messageInterceptors);
    }

    public String getMessageName() {
        return this.delegate.getMessageName();
    }

    public void setMessageName(String messageName) {
        this.delegate.setMessageName(messageName);
    }

    public void setMessageHeaders(Map<String, Object> messageHeaders) {
        this.delegate.setMessageHeaders(messageHeaders);
    }

    public List<String> getHeaderResources() {
        return this.delegate.getHeaderResources();
    }

    public void setHeaderResources(List<String> headerResources) {
        this.delegate.setHeaderResources(headerResources);
    }

    public List<String> getHeaderData() {
        return this.delegate.getHeaderData();
    }

    public void setHeaderData(List<String> headerData) {
        this.delegate.setHeaderData(headerData);
    }

    public Map<String, Object> getMessageHeaders() {
        return this.delegate.getMessageHeaders();
    }

    public Object buildMessagePayload(TestContext context, String messageType) {
        return this.delegate.buildMessagePayload(context, messageType);
    }

    public void add(MessageConstructionInterceptor interceptor) {
        this.delegate.add(interceptor);
    }

    public void setDataDictionary(DataDictionary dataDictionary) {
        this.delegate.setDataDictionary(dataDictionary);
    }

    public AbstractMessageContentBuilder getDelegate() {
        return this.delegate;
    }

    public HttpMessage getMessage() {
        return this.template;
    }
}

