/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AbstractAnnotationConfigParser;
import com.consol.citrus.context.ReferenceResolver;
import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.http.config.annotation.HttpServerConfig;
import com.consol.citrus.http.message.HttpMessageConverter;
import com.consol.citrus.http.server.HttpServer;
import com.consol.citrus.http.server.HttpServerBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Filter;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

public class HttpServerConfigParser
extends AbstractAnnotationConfigParser<HttpServerConfig, HttpServer> {
    public HttpServerConfigParser(ReferenceResolver referenceResolver) {
        super(referenceResolver);
    }

    public HttpServer parse(HttpServerConfig annotation) {
        HttpServerBuilder builder = new HttpServerBuilder();
        builder.autoStart(annotation.autoStart());
        builder.timeout(annotation.timeout());
        builder.handleAttributeHeaders(annotation.handleAttributeHeaders());
        builder.handleCookies(annotation.handleCookies());
        builder.debugLogging(annotation.debugLogging());
        if (StringUtils.hasText((String)annotation.endpointAdapter())) {
            builder.endpointAdapter((EndpointAdapter)this.getReferenceResolver().resolve(annotation.endpointAdapter(), EndpointAdapter.class));
        }
        builder.interceptors(this.getReferenceResolver().resolve(annotation.interceptors(), HandlerInterceptor.class));
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)this.getReferenceResolver().resolve(annotation.actor(), TestActor.class));
        }
        builder.port(annotation.port());
        if (StringUtils.hasText((String)annotation.contextConfigLocation())) {
            builder.contextConfigLocation(annotation.contextConfigLocation());
        }
        if (StringUtils.hasText((String)annotation.resourceBase())) {
            builder.resourceBase(annotation.resourceBase());
        }
        builder.rootParentContext(annotation.rootParentContext());
        builder.connectors(this.getReferenceResolver().resolve(annotation.connectors(), Connector.class));
        List filterBeans = this.getReferenceResolver().resolve(annotation.filters(), Filter.class);
        HashMap<String, Filter> filters = new HashMap<String, Filter>();
        for (int i = 0; i < annotation.filters().length; ++i) {
            filters.put(annotation.filters()[i], (Filter)filterBeans.get(i));
        }
        builder.filters(filters);
        HashMap<String, String> filterMappings = new HashMap<String, String>();
        for (String filterMapping : annotation.filterMappings()) {
            String[] pair = filterMapping.split("=");
            if (pair.length != 2) {
                throw new CitrusRuntimeException("Invalid filter mapping: " + filterMapping);
            }
            filterMappings.put(pair[0], pair[1]);
        }
        builder.filterMappings(filterMappings);
        ArrayList<MediaType> binaryMediaTypes = new ArrayList<MediaType>();
        for (String mediaType : annotation.binaryMediaTypes()) {
            binaryMediaTypes.add(MediaType.valueOf((String)mediaType));
        }
        if (!binaryMediaTypes.isEmpty()) {
            builder.binaryMediaTypes(binaryMediaTypes);
        }
        if (StringUtils.hasText((String)annotation.connector())) {
            builder.connector((Connector)this.getReferenceResolver().resolve(annotation.connector(), Connector.class));
        }
        if (StringUtils.hasText((String)annotation.servletName())) {
            builder.servletName(annotation.servletName());
        }
        if (StringUtils.hasText((String)annotation.servletMappingPath())) {
            builder.servletMappingPath(annotation.servletMappingPath());
        }
        if (StringUtils.hasText((String)annotation.contextPath())) {
            builder.contextPath(annotation.contextPath());
        }
        if (StringUtils.hasText((String)annotation.servletHandler())) {
            builder.servletHandler((ServletHandler)this.getReferenceResolver().resolve(annotation.servletHandler(), ServletHandler.class));
        }
        if (StringUtils.hasText((String)annotation.securityHandler())) {
            builder.securityHandler((SecurityHandler)this.getReferenceResolver().resolve(annotation.securityHandler(), SecurityHandler.class));
        }
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((HttpMessageConverter)this.getReferenceResolver().resolve(annotation.messageConverter(), HttpMessageConverter.class));
        }
        builder.defaultStatus(annotation.defaultStatus());
        return (HttpServer)builder.initialize().build();
    }
}

