/*
 * Decompiled with CFR 0.152.
 */
package com.connect_group.thymeleaf.testing.hamcrest;

import com.connect_group.thymesheet.query.HtmlElement;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.thymeleaf.dom.Comment;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;

public class HasTextBeforeElement
extends TypeSafeMatcher<HtmlElement> {
    private final String value;

    public HasTextBeforeElement(String value) {
        this.value = value;
    }

    public void describeTo(Description description) {
        description.appendText("has text ").appendValue((Object)this.value).appendValue((Object)" before tag");
    }

    public boolean matchesSafely(HtmlElement item) {
        StringBuilder text = new StringBuilder();
        boolean fail = true;
        boolean elementFound = false;
        boolean textFound = false;
        Element element = item.getElement();
        if (element != null && element.hasChildren()) {
            List children = element.getChildren();
            for (Node child : children) {
                if (child instanceof Text) {
                    text.append(((Text)child).getContent());
                    if (elementFound || textFound) {
                        fail = true;
                        break;
                    }
                    textFound = true;
                    continue;
                }
                if (child instanceof Comment) continue;
                elementFound = true;
                if (!textFound) continue;
                fail = false;
            }
        }
        return !fail && text.toString().equals(this.value);
    }
}

