/*
 * Decompiled with CFR 0.152.
 */
package com.connect_group.thymeleaf.testing.hamcrest;

import com.connect_group.thymesheet.query.HtmlElement;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.thymeleaf.dom.Attribute;

public class HasAttribute
extends TypeSafeMatcher<HtmlElement> {
    private final String expectedAttributeName;
    private final String expectedAttributeValue;
    private final boolean testAttributeValue;

    public HasAttribute(String attributeName) {
        this.expectedAttributeName = attributeName;
        this.expectedAttributeValue = null;
        this.testAttributeValue = false;
    }

    public HasAttribute(String attributeName, String attributeValue) {
        this.expectedAttributeName = attributeName;
        this.expectedAttributeValue = attributeValue;
        this.testAttributeValue = true;
    }

    public void describeTo(Description description) {
        if (!this.testAttributeValue) {
            description.appendText("has attribute ").appendValue((Object)this.expectedAttributeName);
        } else {
            description.appendText("has attribute ").appendValue((Object)this.expectedAttributeName).appendText(" with value ").appendValue((Object)this.expectedAttributeValue);
        }
    }

    public boolean matchesSafely(HtmlElement item) {
        boolean hasNamedAttribute = item.getElement().getAttributeMap().containsKey(this.expectedAttributeName);
        if (hasNamedAttribute && this.testAttributeValue) {
            String actualAttributeValue = ((Attribute)item.getElement().getAttributeMap().get(this.expectedAttributeName)).getValue();
            return this.expectedAttributeValue == null && actualAttributeValue == null || this.expectedAttributeValue.equals(actualAttributeValue);
        }
        return hasNamedAttribute;
    }
}

