/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack.stateful;

import com.codepoetics.protonpack.stateful.StateMachine;
import com.codepoetics.protonpack.stateful.Transition;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StateMachineRunner<S, I, O> {
    private S state;
    private boolean isFinished = false;
    private final StateMachine<S, I, O> stateMachine;

    public static <S, I, O> StateMachineRunner<S, I, O> create(S initialState, StateMachine<S, I, O> stateMachine) {
        return new StateMachineRunner<S, I, O>(initialState, stateMachine);
    }

    private StateMachineRunner(S state, StateMachine<S, I, O> stateMachine) {
        this.state = state;
        this.stateMachine = stateMachine;
    }

    public List<O> accept(I input) {
        return this._accept(input).collect(Collectors.toList());
    }

    @SafeVarargs
    public final List<O> accept(I first, I ... remaining) {
        return this.accept(Stream.concat(Stream.of(first), Stream.of(remaining)));
    }

    public List<O> accept(Collection<I> inputs) {
        return this.accept(inputs.stream());
    }

    public List<O> accept(Stream<I> inputs) {
        return inputs.flatMap(this::_accept).collect(Collectors.toList());
    }

    public List<O> acceptAndFinish(I input) {
        List<O> results = this.accept(input);
        this._finish().forEach(results::add);
        return results;
    }

    @SafeVarargs
    public final List<O> acceptAndFinish(I first, I ... remaining) {
        return this.acceptAndFinish(Stream.concat(Stream.of(first), Stream.of(remaining)));
    }

    public List<O> acceptAndFinish(Collection<I> inputs) {
        return this.acceptAndFinish(inputs.stream());
    }

    public List<O> acceptAndFinish(Stream<I> inputs) {
        List<O> results = this.accept(inputs);
        this._finish().forEach(results::add);
        return results;
    }

    private Stream<O> _accept(I input) {
        if (this.isFinished) {
            return Stream.empty();
        }
        Transition<S, O> transition = this.stateMachine.apply(this.state, input);
        this.state = transition.getNewState();
        return transition.getOutputs();
    }

    public List<O> finish() {
        return this._finish().collect(Collectors.toList());
    }

    private Stream<O> _finish() {
        if (this.isFinished) {
            return Stream.empty();
        }
        this.isFinished = true;
        return this.stateMachine.finish(this.state);
    }

    public S getState() {
        return this.state;
    }
}

