/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;

class GroupRunsSpliterator<T>
implements Spliterator<List<T>> {
    private final Spliterator<T> source;
    private final Comparator<T> comparator;
    Optional<T> last = Optional.empty();
    T current = null;

    public GroupRunsSpliterator(Spliterator<T> source, Comparator<T> comparator) {
        this.source = source;
        this.comparator = comparator;
    }

    @Override
    public boolean tryAdvance(Consumer<? super List<T>> action) {
        LinkedList<T> neighbors = new LinkedList<T>();
        this.last.ifPresent(neighbors::add);
        while (this.source.tryAdvance((? super T i) -> {
            this.current = i;
        })) {
            boolean runBroken;
            boolean bl = runBroken = !this.itemBelongsToRun(this.current);
            if (!runBroken) {
                neighbors.add(this.current);
            }
            this.last = Optional.of(this.current);
            if (!runBroken) continue;
            action.accept(neighbors);
            return true;
        }
        return this.flushRemainingNeighbours(action, neighbors);
    }

    private boolean flushRemainingNeighbours(Consumer<? super List<T>> action, List<T> neighbors) {
        if (!neighbors.isEmpty()) {
            action.accept(neighbors);
            this.last = Optional.empty();
            return true;
        }
        return false;
    }

    private boolean itemBelongsToRun(T item) {
        return this.last.map(lastItem -> this.comparator.compare(item, lastItem) == 0).orElse(true);
    }

    @Override
    public Spliterator<List<T>> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.source.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & 0xFFFFFFAF;
    }
}

