/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.minitable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MiniTable {
    private String title;
    private RowType lastRowType;
    private StringBuilder join;
    private List<Row> rows;
    private Map<Integer, Integer> maxColMap;

    public MiniTable() {
        this.init();
    }

    public MiniTable(String title) {
        this.init();
        this.title = title;
    }

    private void init() {
        this.join = new StringBuilder();
        this.rows = new ArrayList<Row>();
        this.maxColMap = new HashMap<Integer, Integer>();
    }

    public MiniTable addHeaders(List<?> headers) {
        return this.appendRows(RowType.HEADER, headers.toArray());
    }

    public MiniTable addHeaders(Object ... objects) {
        return this.appendRows(RowType.HEADER, objects);
    }

    public MiniTable addDatas(List<?> datas) {
        return this.appendRows(RowType.DATA, datas.toArray());
    }

    public MiniTable addDatas(Object ... objects) {
        return this.appendRows(RowType.DATA, objects);
    }

    private MiniTable appendRows(RowType rowType, Object ... objects) {
        int len;
        if (objects != null && (len = objects.length) > 0) {
            if (this.maxColMap.size() > len) {
                throw new IllegalArgumentException("\u5411\u8868\u683c\u4e2d\u63d2\u5165\u67d0\u884c\u6570\u636e\u7684\u5217\u6570\u4e0e\u4e4b\u524d\u7684\u5217\u6570\u4e0d\u540c,\u8bf7\u68c0\u67e5!");
            }
            ArrayList<String> datas = new ArrayList<String>();
            for (int i = 0; i < len; ++i) {
                Object o = objects[i];
                String value = o == null ? "null" : o.toString();
                datas.add(value);
                Integer maxColSize = this.maxColMap.get(i);
                if (maxColSize == null) {
                    this.maxColMap.put(i, value.length());
                    continue;
                }
                if (value.length() <= maxColSize) continue;
                this.maxColMap.put(i, value.length());
            }
            this.rows.add(new Row(rowType, datas));
        }
        return this;
    }

    private void buildTitle() {
        if (this.title != null) {
            int maxTitleSize = 0;
            for (Integer maxColSize : this.maxColMap.values()) {
                maxTitleSize += maxColSize.intValue();
            }
            if (this.title.length() > (maxTitleSize += 3 * (this.maxColMap.size() - 1))) {
                this.title = this.title.substring(0, maxTitleSize);
            }
            this.join.append("+");
            for (int i = 0; i < maxTitleSize + 2; ++i) {
                this.join.append("-");
            }
            this.join.append("+\n").append("|").append(StrUtils.center(this.title, maxTitleSize + 2, ' ')).append("|\n");
            this.lastRowType = RowType.TITLE;
        }
    }

    private void buildTable() {
        this.buildTitle();
        int len = this.rows.size();
        block4: for (int i = 0; i < len; ++i) {
            List datas = this.rows.get(i).datas;
            switch (this.rows.get(i).rowType) {
                case HEADER: {
                    if (this.lastRowType != RowType.HEADER) {
                        this.buildRowBorder(datas);
                    }
                    this.buildRowData(datas);
                    this.buildRowBorder(datas);
                    continue block4;
                }
                case DATA: {
                    this.buildRowData(datas);
                    if (i != len - 1) continue block4;
                    this.buildRowBorder(datas);
                    continue block4;
                }
            }
        }
    }

    private void buildRowBorder(List<String> datas) {
        this.join.append("+");
        int len = datas.size();
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < this.maxColMap.get(i) + 2; ++j) {
                this.join.append("-");
            }
            this.join.append("+");
        }
        this.join.append("\n");
    }

    private void buildRowData(List<String> datas) {
        this.join.append("|");
        int len = datas.size();
        for (int i = 0; i < len; ++i) {
            this.join.append(StrUtils.center(datas.get(i), this.maxColMap.get(i) + 2, ' ')).append("|");
        }
        this.join.append("\n");
    }

    public String render() {
        this.buildTable();
        return this.join.toString();
    }

    private static final class StrUtils {
        private StrUtils() {
        }

        private static String center(String str, int size, char padChar) {
            int strLen;
            int pads;
            if (str != null && size > 0 && (pads = size - (strLen = str.length())) > 0) {
                str = StrUtils.leftPad(str, strLen + pads / 2, padChar);
                str = StrUtils.rightPad(str, size, padChar);
            }
            return str;
        }

        private static String leftPad(String str, int size, char padChar) {
            int pads = size - str.length();
            return pads <= 0 ? str : StrUtils.repeat(padChar, pads).concat(str);
        }

        private static String rightPad(String str, int size, char padChar) {
            int pads = size - str.length();
            return pads <= 0 ? str : str.concat(StrUtils.repeat(padChar, pads));
        }

        private static String repeat(char ch, int repeat) {
            char[] buf = new char[repeat];
            for (int i = repeat - 1; i >= 0; --i) {
                buf[i] = ch;
            }
            return new String(buf);
        }
    }

    private static enum RowType {
        TITLE,
        HEADER,
        DATA;

    }

    private static class Row {
        private RowType rowType;
        private List<String> datas;

        Row(RowType rowType, List<String> datas) {
            this.rowType = rowType;
            this.datas = datas;
        }
    }
}

