/*
 * Decompiled with CFR 0.152.
 */
package com.jmail;

import blade.kit.Assert;
import blade.kit.StringKit;
import blade.kit.config.Config;
import blade.kit.config.loader.ConfigLoader;
import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import com.jmail.MailMessage;
import com.jmail.MailMessageHelper;
import com.jmail.MailSender;
import java.util.Properties;
import java.util.concurrent.Executors;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;

public class MailSenderImpl
implements MailSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailSenderImpl.class);
    private String host;
    private String username;
    private String password;
    private Properties props;
    private boolean debug;

    public MailSenderImpl() {
        this(false);
    }

    public MailSenderImpl(boolean debug) {
        this.debug = debug;
        this.props = new Properties();
        this.props.setProperty("mail.transport.protocol", "smtp");
        this.props.setProperty("mail.smtp.auth", "true");
        this.props.setProperty("mail.smtp.starttls.enable", "true");
    }

    @Override
    public MailSender protocol(String protocol) {
        Assert.notEmpty((CharSequence)protocol, (String)"protocol not is empty!", (Object[])new Object[0]);
        this.props.setProperty("mail.transport.protocol", protocol);
        return this;
    }

    @Override
    public void send(MailMessage ... mailMessages) throws MessagingException {
        Assert.notEmpty((Object[])mailMessages, (String)"mailMessages not is empty!", (Object[])new Object[0]);
        for (MailMessage mailMessage : mailMessages) {
            this.send(mailMessage);
        }
    }

    @Override
    public void send(MailMessage mailMessage) throws MessagingException {
        Assert.notNull((Object)mailMessage, (String)"mailMessage not is null!");
        Session session = Session.getInstance((Properties)this.props);
        session.setDebug(this.debug);
        MimeMessage mimeMessage = new MimeMessage(session);
        MailMessageHelper.copy(mimeMessage, mailMessage);
        LOGGER.debug("send mail...");
        Transport transport = session.getTransport();
        transport.connect(this.host, this.username, this.password);
        transport.sendMessage((Message)mimeMessage, mimeMessage.getRecipients(Message.RecipientType.TO));
        transport.close();
        LOGGER.debug("send success...");
    }

    @Override
    public void send(final MailMessage mailMessage, boolean isAsync) throws MessagingException {
        if (isAsync) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        MailSenderImpl.this.send(mailMessage);
                    }
                    catch (MessagingException e) {
                        e.printStackTrace();
                    }
                }
            };
            Executors.newSingleThreadExecutor().submit(task);
        } else {
            this.send(mailMessage);
        }
    }

    @Override
    public MailSender username(String username) {
        Assert.notEmpty((CharSequence)username, (String)"username not is empty!", (Object[])new Object[0]);
        this.username = username;
        return this;
    }

    @Override
    public MailSender password(String password) {
        Assert.notEmpty((CharSequence)password, (String)"password not is empty!", (Object[])new Object[0]);
        this.password = password;
        return this;
    }

    @Override
    public MailSender auth(boolean auth) {
        this.props.put("mail.smtp.auth", (Object)auth);
        return this;
    }

    @Override
    public MailSender debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    @Override
    public MailSender host(String host) {
        Assert.notEmpty((CharSequence)host, (String)"host not is empty!", (Object[])new Object[0]);
        this.host = host;
        return this;
    }

    @Override
    public MailSender port(int port) {
        this.props.put("mail.smtp.port", (Object)port);
        return this;
    }

    @Override
    public MailSender load(String mailProperties) {
        Config config = ConfigLoader.load((String)mailProperties);
        if (null != config) {
            String user = config.getString("mail.user");
            String pass = config.getString("mail.pass");
            String host = config.getString("mail.smtp.host");
            Integer port = config.getInt("mail.smtp.port");
            if (StringKit.isNotBlank((String)user)) {
                this.username(user);
            }
            if (StringKit.isNotBlank((String)pass)) {
                this.password(pass);
            }
            if (StringKit.isNotBlank((String)host)) {
                this.host(host);
            }
            if (null != port && port > 0) {
                this.port(port);
            }
        }
        return this;
    }
}

