/*
 * Decompiled with CFR 0.152.
 */
package com.jmail;

import blade.kit.StringKit;
import com.jmail.MailMessage;
import com.jmail.exception.MailException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class MailMessageHelper {
    public static void copy(MimeMessage mimeMessage, MailMessage mailMessage) throws MessagingException {
        if (StringKit.isBlank((String)mailMessage.nickName())) {
            mimeMessage.setFrom((Address)new InternetAddress(mailMessage.from()));
        } else {
            String nickName = "";
            try {
                nickName = MimeUtility.encodeText((String)mailMessage.nickName());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            mimeMessage.setFrom((Address)new InternetAddress(nickName + " <" + mailMessage.from() + ">"));
        }
        List<String> to = mailMessage.toList();
        if (null == to || to.size() == 0) {
            throw new MailException("to mail not null.");
        }
        InternetAddress[] addresses = new InternetAddress[to.size()];
        int len = to.size();
        for (int i = 0; i < len; ++i) {
            addresses[i] = new InternetAddress(to.get(i));
        }
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])addresses);
        List<String> cc = mailMessage.ccList();
        if (null != cc && !cc.isEmpty()) {
            InternetAddress[] ccAddresses = new InternetAddress[cc.size()];
            int len2 = cc.size();
            for (int i = 0; i < len2; ++i) {
                ccAddresses[i] = new InternetAddress(cc.get(i));
            }
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
        }
        mimeMessage.setSubject(mailMessage.subject());
        mimeMessage.setSentDate(mailMessage.date());
        MimeMultipart allPart = new MimeMultipart("mixed");
        MimeBodyPart content = MailMessageHelper.createContent(mailMessage.content());
        allPart.addBodyPart((BodyPart)content);
        List<File> attachs = mailMessage.attachs();
        if (null != attachs && !attachs.isEmpty()) {
            for (File file : attachs) {
                MimeBodyPart attach = MailMessageHelper.createAttachment(file);
                allPart.addBodyPart((BodyPart)attach);
            }
        }
        mimeMessage.setContent((Multipart)allPart);
        mimeMessage.saveChanges();
    }

    public static MimeBodyPart createAttachment(File file) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        FileDataSource fds = new FileDataSource(file);
        attachmentPart.setDataHandler(new DataHandler((DataSource)fds));
        attachmentPart.setFileName(fds.getName());
        return attachmentPart;
    }

    public static MimeBodyPart createContent(String body) throws MessagingException {
        MimeBodyPart contentBody = new MimeBodyPart();
        MimeMultipart contentMulti = new MimeMultipart("related");
        MimeBodyPart textBody = new MimeBodyPart();
        textBody.setContent((Object)body, "text/html; charset=utf-8");
        contentMulti.addBodyPart((BodyPart)textBody);
        contentBody.setContent((Multipart)contentMulti);
        return contentBody;
    }
}

