/*
 * Decompiled with CFR 0.152.
 */
package com.jmail;

import blade.kit.Assert;
import com.jmail.exception.MailException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class MailMessage {
    private String from;
    private String nickName;
    private List<String> toList = new ArrayList<String>();
    private List<String> ccList = new ArrayList<String>();
    private List<File> attachs = new ArrayList<File>();
    private String content;
    private String subject;
    private Date date = new Date();

    public MailMessage from(String from) {
        Assert.notEmpty((CharSequence)from, (String)"from mail not is empty!", (Object[])new Object[0]);
        this.from = from;
        return this;
    }

    public MailMessage from(String nickName, String from) {
        Assert.notEmpty((CharSequence)nickName, (String)"nick name not is empty!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)from, (String)"from mail not is empty!", (Object[])new Object[0]);
        this.nickName = nickName;
        this.from = from;
        return this;
    }

    public MailMessage addTo(String to) {
        Assert.notEmpty((CharSequence)to, (String)"to mail not is empty!", (Object[])new Object[0]);
        this.toList.add(to);
        return this;
    }

    public MailMessage addTo(List<String> toList) {
        Assert.notEmpty(toList, (String)"toList mail not is empty!", (Object[])new Object[0]);
        this.toList.addAll(toList);
        return this;
    }

    public MailMessage addTo(String ... to) {
        Assert.notEmpty((Object[])to, (String)"to mail array not is empty!", (Object[])new Object[0]);
        this.toList.addAll(Arrays.asList(to));
        return this;
    }

    public MailMessage addCC(String cc) {
        Assert.notEmpty((CharSequence)cc, (String)"cc mail not is empty!", (Object[])new Object[0]);
        this.ccList.add(cc);
        return this;
    }

    public MailMessage addCC(List<String> ccList) {
        Assert.notEmpty(ccList, (String)"ccList mail not is empty!", (Object[])new Object[0]);
        this.ccList.addAll(ccList);
        return this;
    }

    public MailMessage addCC(String ... cc) {
        Assert.notEmpty((Object[])cc, (String)"cc mail array not is empty!", (Object[])new Object[0]);
        this.ccList.addAll(Arrays.asList(cc));
        return this;
    }

    public MailMessage subject(String subject) {
        Assert.notEmpty((CharSequence)subject, (String)"subject mail not is empty!", (Object[])new Object[0]);
        this.subject = subject;
        return this;
    }

    public MailMessage date(Date date) {
        Assert.notNull((Object)date, (String)"date not is empty!");
        this.date = date;
        return this;
    }

    public MailMessage content(String content) {
        Assert.notEmpty((CharSequence)content, (String)"mail content not is empty!", (Object[])new Object[0]);
        this.content = content;
        return this;
    }

    public MailMessage addFile(String filePath) {
        Assert.notEmpty((CharSequence)filePath, (String)"filePath not is empty!", (Object[])new Object[0]);
        File file = new File(filePath);
        if (null == file || !file.exists()) {
            throw new MailException("the file not exists!");
        }
        return this.addFile(file);
    }

    public MailMessage addFile(String ... filePaths) {
        Assert.notEmpty((Object[])filePaths, (String)"filePaths not is empty!", (Object[])new Object[0]);
        for (String filePath : filePaths) {
            this.addFile(filePath);
        }
        return this;
    }

    public MailMessage addFile(File ... files) {
        Assert.notEmpty((Object[])files, (String)"files not is empty!", (Object[])new Object[0]);
        for (File file : files) {
            this.addFile(file);
        }
        return this;
    }

    public MailMessage addFile(File file) {
        if (null == file || !file.exists()) {
            throw new MailException("the file not exists!");
        }
        this.attachs.add(file);
        return this;
    }

    public String from() {
        return this.from;
    }

    public String nickName() {
        return this.nickName;
    }

    public String content() {
        return this.content;
    }

    public String subject() {
        return this.subject;
    }

    public Date date() {
        return this.date;
    }

    public List<String> toList() {
        return this.toList;
    }

    public List<String> ccList() {
        return this.ccList;
    }

    public List<File> attachs() {
        return this.attachs;
    }
}

