/*
 * Decompiled with CFR 0.152.
 */
package org.patchca.filter.library;

import org.patchca.filter.library.AbstractImageOp;

public abstract class AbstractConvolveImageOp
extends AbstractImageOp {
    private float[][] matrix;

    protected AbstractConvolveImageOp(float[][] matrix) {
        this.matrix = matrix;
    }

    @Override
    protected void filter(int[] inPixels, int[] outPixels, int width, int height) {
        long time1 = System.currentTimeMillis();
        int matrixWidth = this.matrix[0].length;
        int matrixHeight = this.matrix.length;
        int mattrixLeft = -matrixWidth / 2;
        int matrixTop = -matrixHeight / 2;
        for (int y = 0; y < height; ++y) {
            int ytop = y + matrixTop;
            int ybottom = y + matrixTop + matrixHeight;
            for (int x = 0; x < width; ++x) {
                float[] sum = new float[]{0.5f, 0.5f, 0.5f, 0.5f};
                int xleft = x + mattrixLeft;
                int xright = x + mattrixLeft + matrixWidth;
                int matrixY = 0;
                int my = ytop;
                while (my < ybottom) {
                    int matrixX = 0;
                    int mx = xleft;
                    while (mx < xright) {
                        int pixel = this.getPixel(inPixels, mx, my, width, height, 0);
                        float m = this.matrix[matrixY][matrixX];
                        sum[0] = sum[0] + m * (float)(pixel >> 24 & 0xFF);
                        sum[1] = sum[1] + m * (float)(pixel >> 16 & 0xFF);
                        sum[2] = sum[2] + m * (float)(pixel >> 8 & 0xFF);
                        sum[3] = sum[3] + m * (float)(pixel & 0xFF);
                        ++mx;
                        ++matrixX;
                    }
                    ++my;
                    ++matrixY;
                }
                outPixels[x + y * width] = this.limitByte((int)sum[0]) << 24 | this.limitByte((int)sum[1]) << 16 | this.limitByte((int)sum[2]) << 8 | this.limitByte((int)sum[3]);
            }
        }
        long time2 = System.currentTimeMillis() - time1;
    }
}

