/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.resource;

import blade.kit.Assert;
import blade.kit.CollectionKit;
import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import blade.kit.resource.ClassReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractClassReader
implements ClassReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractClassReader.class);

    @Override
    public Set<Class<?>> getClass(String packageName, boolean recursive) {
        return this.getClassByAnnotation(packageName, null, null, recursive);
    }

    @Override
    public Set<Class<?>> getClass(String packageName, Class<?> parent, boolean recursive) {
        return this.getClassByAnnotation(packageName, parent, null, recursive);
    }

    private Set<Class<?>> findClassByPackage(String packageName, String packagePath, Class<?> parent, Class<? extends Annotation> annotation, boolean recursive, Set<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            LOGGER.warn("The package [{}] not found.", packageName);
        }
        if (null != (dirfiles = this.accept(dir, recursive)) && dirfiles.length > 0) {
            for (File file : dirfiles) {
                if (file.isDirectory()) {
                    this.findClassByPackage(packageName + "." + file.getName(), file.getAbsolutePath(), parent, annotation, recursive, classes);
                    continue;
                }
                String className = file.getName().substring(0, file.getName().length() - 6);
                try {
                    Class<?> clazz = Class.forName(packageName + '.' + className);
                    if (null != parent && null != annotation) {
                        if (null == clazz.getSuperclass() || !clazz.getSuperclass().equals(parent) || null == clazz.getAnnotation(annotation)) continue;
                        classes.add(clazz);
                        continue;
                    }
                    if (null != parent) {
                        if (null != clazz.getSuperclass() && clazz.getSuperclass().equals(parent)) {
                            classes.add(clazz);
                            continue;
                        }
                        if (null == clazz.getInterfaces() || clazz.getInterfaces().length <= 0 || !clazz.getInterfaces()[0].equals(parent)) continue;
                        classes.add(clazz);
                        continue;
                    }
                    if (null != annotation) {
                        if (null == clazz.getAnnotation(annotation)) continue;
                        classes.add(clazz);
                        continue;
                    }
                    classes.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("\u5728\u626b\u63cf\u7528\u6237\u5b9a\u4e49\u89c6\u56fe\u65f6\u4ecejar\u5305\u83b7\u53d6\u6587\u4ef6\u51fa\u9519\uff0c\u627e\u4e0d\u5230.class\u7c7b\u6587\u4ef6\uff1a" + e.getMessage());
                }
            }
        }
        return classes;
    }

    private File[] accept(File file, final boolean recursive) {
        File[] dirfiles = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        });
        return dirfiles;
    }

    @Override
    public Set<Class<?>> getClassByAnnotation(String packageName, Class<? extends Annotation> annotation, boolean recursive) {
        return this.getClassByAnnotation(packageName, null, annotation, recursive);
    }

    @Override
    public Set<Class<?>> getClassByAnnotation(String packageName, Class<?> parent, Class<? extends Annotation> annotation, boolean recursive) {
        Assert.notBlank(packageName);
        HashSet<Class<?>> classes = CollectionKit.newHashSet();
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                Set<Class<?>> subClasses = this.findClassByPackage(packageName, filePath, parent, annotation, recursive, classes);
                if (subClasses.size() <= 0) continue;
                classes.addAll(subClasses);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
        }
        return classes;
    }
}

