/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.json;

import blade.kit.json.JSONValue;
import blade.kit.json.JSONWriter;
import java.io.IOException;

class JSONNumber
extends JSONValue {
    private final String string;

    JSONNumber(String string) {
        if (string == null) {
            throw new NullPointerException("string is null");
        }
        this.string = string;
    }

    @Override
    public String toString() {
        return this.string;
    }

    @Override
    void write(JSONWriter writer) throws IOException {
        writer.writeNumber(this.string);
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public Integer asInt() {
        return Integer.parseInt(this.string, 10);
    }

    @Override
    public Long asLong() {
        return Long.parseLong(this.string, 10);
    }

    @Override
    public Float asFloat() {
        return Float.valueOf(Float.parseFloat(this.string));
    }

    @Override
    public Double asDouble() {
        return Double.parseDouble(this.string);
    }

    public Byte asByte() {
        return Byte.parseByte(this.string);
    }

    @Override
    public int hashCode() {
        return this.string.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JSONNumber other = (JSONNumber)object;
        return this.string.equals(other.string);
    }
}

