/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.json;

import blade.kit.StringKit;
import blade.kit.json.JSON;
import blade.kit.json.JSONArray;
import blade.kit.json.JSONObject;
import blade.kit.json.JSONString;
import blade.kit.json.JSONValue;
import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSONHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONHelper.class);

    public static Object toJSONObject(JSONValue value) {
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isNumber()) {
            return value.asInt();
        }
        if (value.isString()) {
            return value.asString();
        }
        if (value.isArray()) {
            return JSONHelper.jsonArrayAsList(value.asArray());
        }
        if (value.isObject()) {
            return JSONHelper.jsonObjectAsMap(value.asJSONObject());
        }
        if (value.isBean()) {
            return JSONHelper.jsonObjectAsMap(value.asJSONObject());
        }
        return null;
    }

    public static <T> T toBean(String json, Class<T> clazz) {
        JSONObject jsonObject = JSON.parse(json).asJSONObject();
        if (null == jsonObject) {
            return null;
        }
        T object = null;
        try {
            PropertyDescriptor[] propertyDescriptors;
            object = clazz.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Object value;
                String name = property.getName();
                if (!jsonObject.contains(name) || null == (value = JSONHelper.getValue(property.getPropertyType(), jsonObject, name))) continue;
                Method setter = property.getWriteMethod();
                setter.invoke(object, value);
            }
        }
        catch (Exception e) {
            LOGGER.error("jsonobject covert to bean error", e);
        }
        return object;
    }

    private static Object getValue(Class<?> type, JSONObject jsonObject, String name) {
        if (null != type && null != jsonObject && StringKit.isNotBlank(name)) {
            if (type.equals(String.class)) {
                return jsonObject.getString(name);
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                return jsonObject.getLong(name);
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                return jsonObject.getDouble(name);
            }
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                return jsonObject.getBoolean(name);
            }
        }
        return null;
    }

    public static Set<Object> jsonArrayAsSet(JSONArray array) {
        HashSet<Object> set = new HashSet<Object>();
        for (JSONValue value : array) {
            set.add(JSONHelper.toJSONObject(value));
        }
        return set;
    }

    public static List<Object> jsonArrayAsList(JSONArray array) {
        ArrayList<Object> list = new ArrayList<Object>(array.size());
        for (JSONValue element : array) {
            list.add(JSONHelper.toJSONObject(element));
        }
        return list;
    }

    public static Map<String, Object> jsonObjectAsMap(JSONObject object) {
        HashMap<String, Object> map = new HashMap<String, Object>(object.size(), 1.0f);
        for (JSONObject.Member member : object) {
            map.put(member.getName(), JSONHelper.toJSONObject(member.getValue()));
        }
        return map;
    }

    public static JSONValue toJSONValue(Object object) {
        if (object == null) {
            return JSON.NULL;
        }
        if (object instanceof Boolean) {
            return JSON.value((Boolean)object);
        }
        if (object instanceof Integer) {
            return JSON.value((Integer)object);
        }
        if (object instanceof Long) {
            return JSON.value((Long)object);
        }
        if (object instanceof Float) {
            return JSON.value((Float)object);
        }
        if (object instanceof Double) {
            return JSON.value((Double)object);
        }
        if (object instanceof String) {
            return JSON.value((String)object);
        }
        if (object instanceof Byte) {
            return JSON.value((Byte)object);
        }
        if (object instanceof Collection) {
            return JSONHelper.toJSONArray((Collection)object);
        }
        if (object instanceof Map) {
            return JSONHelper.mapAsJsonObject((Map)object);
        }
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        return JSONHelper.toJSONObject(object);
    }

    public static JSONArray toJSONArray(Collection<?> collection) {
        JSONArray array = new JSONArray();
        for (Object element : collection) {
            array.add(JSONHelper.toJSONValue(element));
        }
        return array;
    }

    public static JSONObject mapAsJsonObject(Map<?, ?> map) {
        JSONObject object = new JSONObject();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            object.put(String.valueOf(entry.getKey()), JSONHelper.toJSONValue(entry.getValue()));
        }
        return object;
    }

    public static JSONObject toJSONObject(Object bean) {
        Method[] methods;
        Class<?> klass = bean.getClass();
        boolean includeSuperClass = klass.getClassLoader() != null;
        Method[] methodArray = methods = includeSuperClass ? klass.getMethods() : klass.getDeclaredMethods();
        if (null == methods || methods.length == 0) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        int len = methods.length;
        for (int i = 0; i < len; ++i) {
            try {
                Method method = methods[i];
                if (!Modifier.isPublic(method.getModifiers())) continue;
                String name = method.getName();
                String key = "";
                if (name.startsWith("get")) {
                    key = "getClass".equals(name) || "getDeclaringClass".equals(name) ? "" : name.substring(3);
                } else if (name.startsWith("is")) {
                    key = name.substring(2);
                }
                if (key.length() <= 0 || !Character.isUpperCase(key.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (key.length() == 1) {
                    key = key.toLowerCase();
                } else if (!Character.isUpperCase(key.charAt(1))) {
                    key = key.substring(0, 1).toLowerCase() + key.substring(1);
                }
                Object result = method.invoke(bean, (Object[])null);
                if (null == result) continue;
                map.put(key, JSONHelper.wrap(result));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return JSONHelper.mapAsJsonObject(map);
    }

    public static Object wrap(Object object) {
        try {
            String objectPackageName;
            if (object == null) {
                return null;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || JSON.NULL.equals(object) || object instanceof JSONString || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String || object instanceof BigInteger || object instanceof BigDecimal) {
                return object;
            }
            if (object instanceof Collection) {
                Collection coll = (Collection)object;
                return JSONHelper.toJSONArray(coll);
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                return JSONHelper.mapAsJsonObject(map);
            }
            Package objectPackage = object.getClass().getPackage();
            String string = objectPackageName = objectPackage != null ? objectPackage.getName() : "";
            if (objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            return JSONHelper.toJSONObject(object);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

