/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.base;

import blade.kit.Assert;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;

public final class ThrowableKit {
    private ThrowableKit() {
    }

    public static <X extends Throwable> void propagateIfInstanceOf(Throwable throwable, Class<X> declaredType) throws X {
        if (throwable != null && declaredType.isInstance(throwable)) {
            throw (Throwable)declaredType.cast(throwable);
        }
    }

    public static void propagateIfPossible(Throwable throwable) {
        ThrowableKit.propagateIfInstanceOf(throwable, Error.class);
        ThrowableKit.propagateIfInstanceOf(throwable, RuntimeException.class);
    }

    public static <X extends Throwable> void propagateIfPossible(Throwable throwable, Class<X> declaredType) throws X {
        ThrowableKit.propagateIfInstanceOf(throwable, declaredType);
        ThrowableKit.propagateIfPossible(throwable);
    }

    public static <X1 extends Throwable, X2 extends Throwable> void propagateIfPossible(Throwable throwable, Class<X1> declaredType1, Class<X2> declaredType2) throws X1, X2 {
        Assert.notNull(declaredType2);
        ThrowableKit.propagateIfInstanceOf(throwable, declaredType1);
        ThrowableKit.propagateIfPossible(throwable, declaredType2);
    }

    public static RuntimeException propagate(Throwable throwable) {
        ThrowableKit.propagateIfPossible(Assert.checkNotNull(throwable));
        throw new RuntimeException(throwable);
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
        }
        return throwable;
    }

    public static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static RuntimeException unchecked(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof InvocationTargetException) {
            return ThrowableKit.unchecked(((InvocationTargetException)e).getTargetException());
        }
        return new RuntimeException(e);
    }
}

