/*
 * Decompiled with CFR 0.152.
 */
package blade.kit;

import blade.kit.CharKit;
import blade.kit.CollectionKit;
import blade.kit.Emptys;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringKit {
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    private static final String TOP_PATH = "..";
    private static final String CURRENT_PATH = ".";
    public static String[] NUMBER = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u767e", "\u5343", "\u4e07", "\u4ebf"};
    public static final String CREATE = "create";
    public static final String DELETE = "delete";
    public static final String SAVE = "save";
    public static final String UPDATE = "update";
    public static final String QUERY = "query";
    public static final String ERROR = "error";
    public static final String SUCCESS = "success";
    public static final String FAILED = "failed";
    public static final String IP = "strIp";
    public static final String ANSWER = "strAnswer";
    public static final String LOGIN = "login";
    public static final String INDEX = "index";
    public static final String HOME = "home";
    public static final String NORIGHT = "noRight";
    public static final String BOSSIP = "strBOSSIp";
    public static final String BOSSIPS = "BOSSIPS";
    public static final String BOSSANSWER = "BOSSANSWER";
    private static final String RANDOM_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isAnyEmpty(String ... strings) {
        if (strings == null) {
            return true;
        }
        for (String string : strings) {
            if (!StringKit.isEmpty(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotEmpty(String str) {
        return !StringKit.isEmpty(str);
    }

    public static boolean isBlank(String str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllBlank(String ... strings) {
        if (strings == null) {
            return true;
        }
        for (String string : strings) {
            if (!StringKit.isNotBlank(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyBlank(String ... strings) {
        if (strings == null) {
            return true;
        }
        for (String string : strings) {
            if (!StringKit.isBlank(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotBlank(String str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String defaultIfNull(String str) {
        return str == null ? "" : str;
    }

    public static String defaultIfNull(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static String trim(String str) {
        return StringKit.trim(str, null, 0);
    }

    public static void trimAll(String[] strings) {
        if (strings == null) {
            return;
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            if (string == null) continue;
            strings[i] = StringKit.trim(string);
        }
    }

    public static String trim(String str, String stripChars) {
        return StringKit.trim(str, stripChars, 0);
    }

    public static String trimStart(String str) {
        return StringKit.trim(str, null, -1);
    }

    public static String trimStart(String str, String stripChars) {
        return StringKit.trim(str, stripChars, -1);
    }

    public static String trimEnd(String str) {
        return StringKit.trim(str, null, 1);
    }

    public static String trimEnd(String str, String stripChars) {
        return StringKit.trim(str, stripChars, 1);
    }

    public static String trimToNull(String str) {
        return StringKit.trimToNull(str, null);
    }

    public static String trimToNull(String str, String stripChars) {
        String result = StringKit.trim(str, stripChars);
        if (result == null || result.length() == 0) {
            return null;
        }
        return result;
    }

    public static String trimToEmpty(String str) {
        return StringKit.trimToEmpty(str, null);
    }

    public static String trimToEmpty(String str, String stripChars) {
        String result = StringKit.trim(str, stripChars);
        if (result == null) {
            return "";
        }
        return result;
    }

    private static String trim(String str, String stripChars, int mode) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        int end = length;
        if (mode <= 0) {
            if (stripChars == null) {
                for (start = 0; start < end && Character.isWhitespace(str.charAt(start)); ++start) {
                }
            } else {
                if (stripChars.length() == 0) {
                    return str;
                }
                while (start < end && str.startsWith(stripChars) && stripChars.indexOf(str.charAt(start)) != -1) {
                    ++start;
                }
            }
        }
        if (mode >= 0) {
            if (stripChars == null) {
                while (start < end && Character.isWhitespace(str.charAt(end - 1))) {
                    --end;
                }
            } else {
                if (stripChars.length() == 0) {
                    return str;
                }
                while (start < end && str.endsWith(stripChars) && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                    --end;
                }
            }
        }
        if (start > 0 || end < length) {
            return str.substring(start, end);
        }
        return str;
    }

    public static boolean equals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static int equalsOne(String src, String[] dest) {
        if (src == null || dest == null) {
            return -1;
        }
        for (int i = 0; i < dest.length; ++i) {
            if (!src.equals(dest[i])) continue;
            return i;
        }
        return -1;
    }

    public static int equalsOneIgnoreCase(String src, String[] dest) {
        if (src == null || dest == null) {
            return -1;
        }
        for (int i = 0; i < dest.length; ++i) {
            if (!src.equalsIgnoreCase(dest[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean equalsIgnoreCase(String[] as, String[] as1) {
        if (as == null && as1 == null) {
            return true;
        }
        if (as == null || as1 == null) {
            return false;
        }
        if (as.length != as1.length) {
            return false;
        }
        for (int i = 0; i < as.length; ++i) {
            if (as[i].equalsIgnoreCase(as1[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlpha(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isLetter(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaSpace(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isLetter(str.charAt(i)) || str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumeric(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isLetterOrDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumericSpace(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isLetterOrDigit(str.charAt(i)) || str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumericSpace(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(str.charAt(i)) || str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String toUpperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String toLowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static String uncapitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toLowerCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static String decapitalize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.length() > 1 && Character.isUpperCase(str.charAt(1)) && Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        char[] chars = str.toCharArray();
        char c = chars[0];
        char modifiedChar = Character.toLowerCase(c);
        if (modifiedChar == c) {
            return str;
        }
        chars[0] = modifiedChar;
        return new String(chars);
    }

    public static String swapCase(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        StringBuilder builder = new StringBuilder(strLen);
        char ch = '\u0000';
        for (int i = 0; i < strLen; ++i) {
            ch = str.charAt(i);
            if (Character.isUpperCase(ch)) {
                ch = Character.toLowerCase(ch);
            } else if (Character.isTitleCase(ch)) {
                ch = Character.toLowerCase(ch);
            } else if (Character.isLowerCase(ch)) {
                ch = Character.toUpperCase(ch);
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    public static String fromCamelCase(String str, char separator) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        StringBuilder result = new StringBuilder(strLen * 2);
        int resultLength = 0;
        boolean prevTranslated = false;
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (i <= 0 && c == separator) continue;
            if (Character.isUpperCase(c)) {
                if (!prevTranslated && resultLength > 0 && result.charAt(resultLength - 1) != separator) {
                    result.append(separator);
                    ++resultLength;
                }
                c = Character.toLowerCase(c);
                prevTranslated = true;
            } else {
                prevTranslated = false;
            }
            result.append(c);
            ++resultLength;
        }
        return resultLength > 0 ? result.toString() : str;
    }

    public static short toShort(String s, short def) {
        try {
            return StringKit.isEmpty(s) ? def : Short.parseShort(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static int toInt(String s, int def) {
        try {
            return StringKit.isEmpty(s) ? def : Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static long toLong(String s, long def) {
        try {
            return StringKit.isEmpty(s) ? def : Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static float toFloat(String s, float def) {
        try {
            return StringKit.isEmpty(s) ? def : Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static double toDouble(String s, double def) {
        try {
            return StringKit.isEmpty(s) ? def : Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static boolean toBoolean(String s, boolean def) {
        if (StringKit.isEmpty(s)) {
            return def;
        }
        return "true".equalsIgnoreCase(s);
    }

    public static String getDelFormat(Object f) {
        DecimalFormat df = new DecimalFormat("0.0");
        return df.format(f);
    }

    public static String getDelFormat2(Object f) {
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(f);
    }

    public static String getDelFormat3(Object f) {
        DecimalFormat df = new DecimalFormat("0.000");
        return df.format(f);
    }

    public static String getStringsubstr(String source, int len) {
        if (null == source || "".equals(source)) {
            return "";
        }
        if (source.length() > len) {
            return source.substring(0, len) + "...";
        }
        return source;
    }

    public static String getRandomNumber(int length, int max) {
        Random random = new Random();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buffer.append(random.nextInt(max));
        }
        return buffer.toString();
    }

    public static String getRandomNumber(int size) {
        String num = "";
        for (int i = 0; i < size; ++i) {
            double a = Math.random() * 9.0;
            a = Math.ceil(a);
            int randomNum = new Double(a).intValue();
            num = num + randomNum;
        }
        return num;
    }

    public static String getRandomChar(int size) {
        String sRand = "";
        Random random = new Random();
        for (int i = 0; i < size; ++i) {
            String ch = String.valueOf(RANDOM_CHAR.charAt(random.nextInt(RANDOM_CHAR.length())));
            sRand = sRand + ch;
        }
        return sRand;
    }

    public static boolean isNumber(String str) {
        return null != str && 0 != str.trim().length() && str.matches("\\d*");
    }

    public static boolean isBoolean(String value) {
        String val;
        return null != value && ((val = value.toLowerCase()).equals("true") || val.equals("false"));
    }

    public static String toChineseNumber(int number, int depth) {
        if (depth < 0) {
            depth = 0;
        }
        if (number <= 0 && depth == 0) {
            return NUMBER[0];
        }
        String chinese = "";
        String src = number + "";
        if (src.charAt(src.length() - 1) == 'l' || src.charAt(src.length() - 1) == 'L') {
            src = src.substring(0, src.length() - 1);
        }
        if (src.length() > 4) {
            chinese = StringKit.toChineseNumber(Integer.parseInt(src.substring(0, src.length() - 4)), depth + 1) + StringKit.toChineseNumber(Integer.parseInt(src.substring(src.length() - 4, src.length())), depth - 1);
        } else {
            int prv = 0;
            block17: for (int i = 0; i < src.length(); ++i) {
                switch (src.charAt(i)) {
                    case '0': {
                        if (prv == 48) break;
                        chinese = chinese + NUMBER[0];
                        break;
                    }
                    case '1': {
                        chinese = chinese + NUMBER[1];
                        break;
                    }
                    case '2': {
                        chinese = chinese + NUMBER[2];
                        break;
                    }
                    case '3': {
                        chinese = chinese + NUMBER[3];
                        break;
                    }
                    case '4': {
                        chinese = chinese + NUMBER[4];
                        break;
                    }
                    case '5': {
                        chinese = chinese + NUMBER[5];
                        break;
                    }
                    case '6': {
                        chinese = chinese + NUMBER[6];
                        break;
                    }
                    case '7': {
                        chinese = chinese + NUMBER[7];
                        break;
                    }
                    case '8': {
                        chinese = chinese + NUMBER[8];
                        break;
                    }
                    case '9': {
                        chinese = chinese + NUMBER[9];
                    }
                }
                prv = src.charAt(i);
                switch (src.length() - 1 - i) {
                    case 1: {
                        if (prv == 48) continue block17;
                        chinese = chinese + NUMBER[10];
                        continue block17;
                    }
                    case 2: {
                        if (prv == 48) continue block17;
                        chinese = chinese + NUMBER[11];
                        continue block17;
                    }
                    case 3: {
                        if (prv == 48) continue block17;
                        chinese = chinese + NUMBER[12];
                    }
                }
            }
        }
        while (chinese.length() > 0 && chinese.lastIndexOf(NUMBER[0]) == chinese.length() - 1) {
            chinese = chinese.substring(0, chinese.length() - 1);
        }
        if (depth == 1) {
            chinese = chinese + NUMBER[13];
        }
        if (depth == 2) {
            chinese = chinese + NUMBER[14];
        }
        return chinese;
    }

    public static boolean checkIsEnglish(String s) {
        String Letters = "(){}[]\",.<>\\/~!@#$%^&*;': ";
        if (s.charAt(0) == '-') {
            return false;
        }
        if (s.charAt(s.length() - 1) == '-') {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Letters.indexOf(c) <= -1) continue;
            return false;
        }
        boolean yesorno = StringKit.isChineseStr(s);
        return !yesorno;
    }

    public static boolean isChineseStr(String pValue) {
        for (int i = 0; i < pValue.length(); ++i) {
            if (pValue.charAt(i) <= '\u0100') continue;
            return true;
        }
        return false;
    }

    public static boolean isLetter(char c) {
        int k = 128;
        return c / k == 0;
    }

    public static final String FormatDecimalString(String decimal) {
        double dValue = Double.valueOf(decimal);
        DecimalFormat df = new DecimalFormat();
        String positivePattern = " ,000";
        String negativePattern = " ,000";
        if (dValue < 0.0) {
            df.applyPattern(negativePattern);
            return df.format(dValue).replace(',', ',');
        }
        df.applyPattern(positivePattern);
        return df.format(dValue).replace(',', ',');
    }

    public static String getNumberFormat(long source) {
        NumberFormat usFormat = NumberFormat.getIntegerInstance(Locale.US);
        return usFormat.format(source);
    }

    public static String stringFilter(String str) {
        String[][] FilterChars = new String[][]{{"<", "&lt;"}, {">", "&gt;"}, {" ", "&nbsp;"}, {"\"", "&quot;"}, {"&", "&amp;"}, {FOLDER_SEPARATOR, "&#47;"}, {WINDOWS_FOLDER_SEPARATOR, "&#92;"}, {"'", "\\'"}, {"%", "%"}};
        String[] str_arr = StringKit.stringSpilit(str, "");
        for (int i = 0; i < str_arr.length; ++i) {
            for (int j = 0; j < FilterChars.length; ++j) {
                if (!FilterChars[j][0].equals(str_arr[i])) continue;
                str_arr[i] = FilterChars[j][1];
            }
        }
        return StringKit.stringConnect(str_arr, "").trim();
    }

    public static String stringKeyWorldFilter(String str) {
        String[][] FilterChars = new String[][]{{"<", ""}, {">", ""}, {"\"", ""}, {"&", ""}, {FOLDER_SEPARATOR, ""}, {WINDOWS_FOLDER_SEPARATOR, ""}, {"'", ""}, {"%", ""}};
        String[] str_arr = StringKit.stringSpilit(str, "");
        for (int i = 0; i < str_arr.length; ++i) {
            for (int j = 0; j < FilterChars.length; ++j) {
                if (!FilterChars[j][0].equals(str_arr[i])) continue;
                str_arr[i] = FilterChars[j][1];
            }
        }
        return StringKit.stringConnect(str_arr, "").trim();
    }

    public static String escapeJavaScript(String value) {
        return StringKit.escapeJava(value);
    }

    public static String unescapeJavaScript(String value) {
        return StringKit.unescapeJava(value);
    }

    public static String escapeJava(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        int len = value.length();
        StringBuilder buf = null;
        for (int i = 0; i < len; ++i) {
            String rep;
            char ch = value.charAt(i);
            switch (ch) {
                case '\\': {
                    rep = "\\\\";
                    break;
                }
                case '\"': {
                    rep = "\\\"";
                    break;
                }
                case '\'': {
                    rep = "\\'";
                    break;
                }
                case '\t': {
                    rep = "\\t";
                    break;
                }
                case '\n': {
                    rep = "\\n";
                    break;
                }
                case '\r': {
                    rep = "\\r";
                    break;
                }
                case '\b': {
                    rep = "\\b";
                    break;
                }
                case '\f': {
                    rep = "\\f";
                    break;
                }
                default: {
                    rep = null;
                }
            }
            if (rep != null) {
                if (buf == null) {
                    buf = new StringBuilder(len * 2);
                    if (i > 0) {
                        buf.append(value.substring(0, i));
                    }
                }
                buf.append(rep);
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        if (buf != null) {
            return buf.toString();
        }
        return value;
    }

    public static String unescapeJava(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        StringBuilder buf = null;
        int len = value.length();
        int len1 = len - 1;
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch == '\\' && i < len1) {
                int j = i++;
                ch = value.charAt(i);
                switch (ch) {
                    case '\\': {
                        ch = '\\';
                        break;
                    }
                    case '\"': {
                        ch = '\"';
                        break;
                    }
                    case '\'': {
                        ch = '\'';
                        break;
                    }
                    case 't': {
                        ch = '\t';
                        break;
                    }
                    case 'n': {
                        ch = '\n';
                        break;
                    }
                    case 'r': {
                        ch = '\r';
                        break;
                    }
                    case 'b': {
                        ch = '\b';
                        break;
                    }
                    case 'f': {
                        ch = '\f';
                        break;
                    }
                    case 'u': {
                        ch = (char)Integer.parseInt(value.substring(i + 1, i + 5), 16);
                        i += 4;
                        break;
                    }
                    default: {
                        --j;
                    }
                }
                if (buf == null) {
                    buf = new StringBuilder(len);
                    if (j > 0) {
                        buf.append(value.substring(0, j));
                    }
                }
                buf.append(ch);
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        if (buf != null) {
            return buf.toString();
        }
        return value;
    }

    public static String[] stringSpilit(String str, String spilit_sign) {
        String[] spilit_string = str.split(spilit_sign);
        if (spilit_string[0].equals("")) {
            String[] new_string = new String[spilit_string.length - 1];
            for (int i = 1; i < spilit_string.length; ++i) {
                new_string[i - 1] = spilit_string[i];
            }
            return new_string;
        }
        return spilit_string;
    }

    public static String stringConnect(String[] strings, String spilit_sign) {
        StringBuffer str = new StringBuffer("");
        for (int i = 0; i < strings.length; ++i) {
            str.append(strings[i]).append(spilit_sign);
        }
        return str.toString();
    }

    public static int getRound(double dSource) {
        BigDecimal deSource = new BigDecimal(dSource);
        int iRound = deSource.setScale(0, 4).intValue();
        return iRound;
    }

    public static double round(double s) {
        BigDecimal b = new BigDecimal(Double.toString(s));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, 4).doubleValue();
    }

    public static long roundlong(double s) {
        BigDecimal b = new BigDecimal(Double.toString(s));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, 4).longValue();
    }

    public static int length(String s) {
        if (s == null) {
            return 0;
        }
        char[] c = s.toCharArray();
        int len = 0;
        for (int i = 0; i < c.length; ++i) {
            ++len;
            if (StringKit.isLetter(c[i])) continue;
            ++len;
        }
        return len;
    }

    public static String getStrByCharset(String str, String charset) throws UnsupportedEncodingException {
        return new String(str.getBytes("ISO-8859-1"), charset);
    }

    public static String getChineseByStr(String str) {
        StringBuilder resultStr = new StringBuilder("");
        Pattern pcn = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = pcn.matcher(str);
        while (m.find()) {
            resultStr.append(m.group().toString());
        }
        return resultStr.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String parseStrInt(String strDouble) {
        String fen = "";
        int dotIndex = strDouble.lastIndexOf(CURRENT_PATH);
        if (dotIndex < 0) return strDouble + "00";
        String zs = strDouble.substring(0, dotIndex);
        if (!StringKit.isNumber(zs)) {
            return null;
        }
        fen = zs;
        if (strDouble.substring(dotIndex).length() <= 1) return null;
        String xs = strDouble.substring(dotIndex).substring(1);
        if (!StringKit.isNumber(xs)) {
            return null;
        }
        if (xs.length() >= 3) {
            xs = xs.substring(0, 2);
            return zs + xs;
        } else {
            if (xs.length() >= 2) return zs + xs;
            xs = xs + "0";
        }
        return zs + xs;
    }

    public static boolean checkFloat(String num, String type) {
        String eL = "";
        eL = type.equals("0+") ? "^\\d+(\\.\\d+)?$" : (type.equals("+") ? "^((\\d+\\.\\d*[1-9]\\d*)|(\\d*[1-9]\\d*\\.\\d+)|(\\d*[1-9]\\d*))$" : (type.equals("-0") ? "^((-\\d+(\\.\\d+)?)|(0+(\\.0+)?))$" : (type.equals("-") ? "^(-((\\d+\\.\\d*[1-9]\\d*)|(\\d*[1-9]\\d*\\.\\d+)|(\\d*[1-9]\\d*)))$" : "^(-?\\d+)(\\.\\d+)?$")));
        Pattern p = Pattern.compile(eL);
        Matcher m = p.matcher(num);
        boolean b = m.matches();
        return b;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (StringKit.isEmpty(inString) || StringKit.isEmpty(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (StringKit.isEmpty(inString) || StringKit.isEmpty(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getFilename(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String applyRelativePath(String path, String relativePath) {
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (separatorIndex != -1) {
            String newPath = path.substring(0, separatorIndex);
            if (!relativePath.startsWith(FOLDER_SEPARATOR)) {
                newPath = newPath + FOLDER_SEPARATOR;
            }
            return newPath + relativePath;
        }
        return relativePath;
    }

    public static String cleanPath(String path) {
        int i;
        if (path == null) {
            return null;
        }
        String pathToUse = StringKit.replace(path, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            pathToUse = pathToUse.substring(prefixIndex + 1);
        }
        if (pathToUse.startsWith(FOLDER_SEPARATOR)) {
            prefix = prefix + FOLDER_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = StringKit.delimitedListToStringArray(pathToUse, FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (CURRENT_PATH.equals(element)) continue;
            if (TOP_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, TOP_PATH);
        }
        return prefix + StringKit.collectionToDelimitedString(pathElements, FOLDER_SEPARATOR);
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        return StringKit.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if ("".equals(delimiter)) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(StringKit.deleteAny(str.substring(i, i + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(StringKit.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(StringKit.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return StringKit.toStringArray(result);
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim, String prefix, String suffix) {
        if (CollectionKit.isEmpty(coll)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim) {
        return StringKit.collectionToDelimitedString(coll, delim, "", "");
    }

    public static String firstUpperCase(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String join(String[] array, String separator) {
        if (array == null) {
            return null;
        }
        int noOfItems = array.length;
        if (noOfItems <= 0) {
            return null;
        }
        if (noOfItems == 1) {
            return array[0].toString();
        }
        StringBuilder buf = new StringBuilder(noOfItems * 16);
        for (int i = 0; i < noOfItems; ++i) {
            buf.append(separator);
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        int noOfItems = array.length;
        if (noOfItems <= 0) {
            return null;
        }
        if (noOfItems == 1) {
            return array[0].toString();
        }
        StringBuilder buf = new StringBuilder(noOfItems * 16);
        for (int i = 0; i < noOfItems; ++i) {
            buf.append(separator);
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static <T> String join(List<T> array, String separator) {
        if (array == null) {
            return null;
        }
        int noOfItems = array.size();
        if (noOfItems <= 0) {
            return null;
        }
        if (noOfItems == 1) {
            return array.get(0).toString();
        }
        StringBuilder buf = new StringBuilder(noOfItems * 16);
        for (int i = 0; i < noOfItems; ++i) {
            buf.append(separator);
            if (array.get(i) == null) continue;
            buf.append(array.get(i));
        }
        return buf.toString();
    }

    public static String join(String ... parts) {
        StringBuilder sb = new StringBuilder(parts.length);
        for (String part : parts) {
            sb.append(part);
        }
        return sb.toString();
    }

    public static String join(Iterable<?> elements, String separator) {
        if (elements == null) {
            return "";
        }
        return StringKit.join(elements.iterator(), separator);
    }

    public static String join(Iterator<?> elements, String separator) {
        if (elements == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (elements.hasNext()) {
            Object o = elements.next();
            if (sb.length() > 0 && separator != null) {
                sb.append(separator);
            }
            sb.append(o);
        }
        return sb.toString();
    }

    public static String getUUID() {
        String uuid = UUID.randomUUID().toString();
        return uuid.substring(0, 8) + uuid.substring(9, 13) + uuid.substring(14, 18) + uuid.substring(19, 23) + uuid.substring(24);
    }

    public static String random(int length) {
        if (length <= 0) {
            return "";
        }
        char[] randomChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'z', 'x', 'c', 'v', 'b', 'n', 'm'};
        Random random = new Random();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            stringBuffer.append(randomChar[Math.abs(random.nextInt()) % randomChar.length]);
        }
        return stringBuffer.toString();
    }

    public static List<String> split(String str, int length) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < str.length(); i += length) {
            int endIndex = i + length;
            if (endIndex <= str.length()) {
                list.add(str.substring(i, i + length));
                continue;
            }
            list.add(str.substring(i, str.length() - 1));
        }
        return list;
    }

    public static String[] split(String str) {
        return StringKit.split(str, null, -1);
    }

    public static List<Long> parseStringToLongList(String source, String token) {
        String[] units;
        if (StringKit.isBlank(source) || StringKit.isEmpty(token)) {
            return null;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (String unit : units = source.split(token)) {
            result.add(Long.valueOf(unit));
        }
        return result;
    }

    public static String[] splitNoCompress(String src, String delimiter) {
        int i;
        if (src == null || delimiter == null) {
            return null;
        }
        int maxparts = src.length() / delimiter.length() + 2;
        int[] positions = new int[maxparts];
        int dellen = delimiter.length();
        int j = 0;
        int count = 0;
        positions[0] = -dellen;
        while ((i = src.indexOf(delimiter, j)) != -1) {
            positions[++count] = i;
            j = i + dellen;
        }
        positions[++count] = src.length();
        String[] result = new String[count];
        for (i = 0; i < count; ++i) {
            result[i] = src.substring(positions[i] + dellen, positions[i + 1]);
        }
        return result;
    }

    public static String[] splitc(String src, String d) {
        if (StringKit.isAnyEmpty(src, d)) {
            return new String[]{src};
        }
        char[] delimiters = d.toCharArray();
        char[] srcc = src.toCharArray();
        int maxparts = srcc.length + 1;
        int[] start = new int[maxparts];
        int[] end = new int[maxparts];
        int count = 0;
        start[0] = 0;
        int s = 0;
        if (CharKit.equalsOne(srcc[0], delimiters)) {
            end[0] = 0;
            ++count;
            s = CharKit.findFirstDiff(srcc, 1, delimiters);
            if (s == -1) {
                return new String[]{"", ""};
            }
            start[1] = s;
        }
        while (true) {
            int e;
            if ((e = CharKit.findFirstEqual(srcc, s, delimiters)) == -1) {
                end[count] = srcc.length;
                break;
            }
            end[count] = e;
            ++count;
            s = CharKit.findFirstDiff(srcc, e, delimiters);
            if (s == -1) {
                start[count] = end[count] = srcc.length;
                break;
            }
            start[count] = s;
        }
        String[] result = new String[++count];
        for (int i = 0; i < count; ++i) {
            result[i] = src.substring(start[i], end[i]);
        }
        return result;
    }

    public static String[] splitc(String src, char delimiter) {
        if (StringKit.isEmpty(src)) {
            return new String[]{""};
        }
        char[] srcc = src.toCharArray();
        int maxparts = srcc.length + 1;
        int[] start = new int[maxparts];
        int[] end = new int[maxparts];
        int count = 0;
        start[0] = 0;
        int s = 0;
        if (srcc[0] == delimiter) {
            end[0] = 0;
            ++count;
            s = CharKit.findFirstDiff(srcc, 1, delimiter);
            if (s == -1) {
                return new String[]{"", ""};
            }
            start[1] = s;
        }
        while (true) {
            int e;
            if ((e = CharKit.findFirstEqual(srcc, s, delimiter)) == -1) {
                end[count] = srcc.length;
                break;
            }
            end[count] = e;
            ++count;
            s = CharKit.findFirstDiff(srcc, e, delimiter);
            if (s == -1) {
                start[count] = end[count] = srcc.length;
                break;
            }
            start[count] = s;
        }
        String[] result = new String[++count];
        for (int i = 0; i < count; ++i) {
            result[i] = src.substring(start[i], end[i]);
        }
        return result;
    }

    public static String[] splitc(String src, char[] delimiters) {
        if (StringKit.isEmpty(src) || null == delimiters || delimiters.length == 0) {
            return new String[]{src};
        }
        char[] srcc = src.toCharArray();
        int maxparts = srcc.length + 1;
        int[] start = new int[maxparts];
        int[] end = new int[maxparts];
        int count = 0;
        start[0] = 0;
        int s = 0;
        if (CharKit.equalsOne(srcc[0], delimiters)) {
            end[0] = 0;
            ++count;
            s = CharKit.findFirstDiff(srcc, 1, delimiters);
            if (s == -1) {
                return new String[]{"", ""};
            }
            start[1] = s;
        }
        while (true) {
            int e;
            if ((e = CharKit.findFirstEqual(srcc, s, delimiters)) == -1) {
                end[count] = srcc.length;
                break;
            }
            end[count] = e;
            ++count;
            s = CharKit.findFirstDiff(srcc, e, delimiters);
            if (s == -1) {
                start[count] = end[count] = srcc.length;
                break;
            }
            start[count] = s;
        }
        String[] result = new String[++count];
        for (int i = 0; i < count; ++i) {
            result[i] = src.substring(start[i], end[i]);
        }
        return result;
    }

    public static String[] split(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return Emptys.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = CollectionKit.createArrayList();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < length) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] split(String str, String separatorChars) {
        return StringKit.split(str, separatorChars, -1);
    }

    public static String[] split(String str, String separatorChars, int max) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return Emptys.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = CollectionKit.createArrayList();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        if (separatorChars == null) {
            while (i < length) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = length;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < length) {
                if (str.charAt(i) == sep) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = length;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        } else {
            while (i < length) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = length;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String arrayToCommaDelimitedString(Object[] arr) {
        return StringKit.arrayToDelimitedString(arr, ",");
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        if (arr.length == 1) {
            return StringKit.nullSafeToString(arr[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            if (o1 instanceof Object[] && o2 instanceof Object[]) {
                return Arrays.equals((Object[])o1, (Object[])o2);
            }
            if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
                return Arrays.equals((boolean[])o1, (boolean[])o2);
            }
            if (o1 instanceof byte[] && o2 instanceof byte[]) {
                return Arrays.equals((byte[])o1, (byte[])o2);
            }
            if (o1 instanceof char[] && o2 instanceof char[]) {
                return Arrays.equals((char[])o1, (char[])o2);
            }
            if (o1 instanceof double[] && o2 instanceof double[]) {
                return Arrays.equals((double[])o1, (double[])o2);
            }
            if (o1 instanceof float[] && o2 instanceof float[]) {
                return Arrays.equals((float[])o1, (float[])o2);
            }
            if (o1 instanceof int[] && o2 instanceof int[]) {
                return Arrays.equals((int[])o1, (int[])o2);
            }
            if (o1 instanceof long[] && o2 instanceof long[]) {
                return Arrays.equals((long[])o1, (long[])o2);
            }
            if (o1 instanceof short[] && o2 instanceof short[]) {
                return Arrays.equals((short[])o1, (short[])o2);
            }
        }
        return false;
    }

    public static String nullSafeToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Object[]) {
            return StringKit.nullSafeToString((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return StringKit.nullSafeToString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return StringKit.nullSafeToString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return StringKit.nullSafeToString((char[])obj);
        }
        if (obj instanceof double[]) {
            return StringKit.nullSafeToString((double[])obj);
        }
        if (obj instanceof float[]) {
            return StringKit.nullSafeToString((float[])obj);
        }
        if (obj instanceof int[]) {
            return StringKit.nullSafeToString((int[])obj);
        }
        if (obj instanceof long[]) {
            return StringKit.nullSafeToString((long[])obj);
        }
        if (obj instanceof short[]) {
            return StringKit.nullSafeToString((short[])obj);
        }
        String str = obj.toString();
        return str != null ? str : "";
    }

    public static String toString(List<String> list, String separator) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String str : list) {
            stringBuffer.append(separator + str);
        }
        stringBuffer.deleteCharAt(0);
        return stringBuffer.toString();
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static String toString(Collection<String> collection) {
        return StringKit.toString(collection, " ");
    }

    public static String toString(Collection<String> collection, String split) {
        if (collection == null || split == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String object : collection) {
            builder.append((Object)object).append(split);
        }
        builder.setLength(builder.length() - split.length());
        return builder.toString();
    }
}

