/*
 * Decompiled with CFR 0.152.
 */
package blade.kit;

import blade.kit.Assert;
import blade.kit.CollectionKit;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public abstract class ExceptionKit {
    public static void makeRunTimeWhen(boolean flag, String message, Object ... args) {
        if (flag) {
            message = String.format(message, args);
            RuntimeException e = new RuntimeException(message);
            throw ExceptionKit.correctStackTrace(e);
        }
    }

    public static void makeRunTime() {
        RuntimeException e = new RuntimeException();
        throw ExceptionKit.correctStackTrace(e);
    }

    public static void makeRunTime(String message, Object ... args) {
        message = String.format(message, args);
        RuntimeException e = new RuntimeException(message);
        throw ExceptionKit.correctStackTrace(e);
    }

    public static void makeRuntime(Throwable cause) {
        RuntimeException e = new RuntimeException(cause);
        throw ExceptionKit.correctStackTrace(e);
    }

    public static void makeRuntime(String message, Throwable cause, Object ... args) {
        message = String.format(message, args);
        RuntimeException e = new RuntimeException(message, cause);
        throw ExceptionKit.correctStackTrace(e);
    }

    private static RuntimeException correctStackTrace(RuntimeException e) {
        StackTraceElement[] s = e.getStackTrace();
        if (null != s && s.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(s, 1, s.length));
        }
        return e;
    }

    public static boolean causedBy(Throwable throwable, Class<? extends Throwable> causeType) {
        Assert.notNull(causeType, "causeType");
        HashSet<Throwable> causes = CollectionKit.createHashSet();
        while (throwable != null && !causeType.isInstance(throwable) && !causes.contains(throwable)) {
            causes.add(throwable);
            throwable = throwable.getCause();
        }
        return throwable != null && causeType.isInstance(throwable);
    }

    public static Throwable getRootCause(Throwable throwable) {
        List<Throwable> causes = ExceptionKit.getCauses(throwable, true);
        return causes.isEmpty() ? null : causes.get(0);
    }

    public static List<Throwable> getCauses(Throwable throwable) {
        return ExceptionKit.getCauses(throwable, false);
    }

    public static List<Throwable> getCauses(Throwable throwable, boolean reversed) {
        LinkedList<Throwable> causes = CollectionKit.createLinkedList();
        while (throwable != null && !causes.contains(throwable)) {
            if (reversed) {
                causes.addFirst(throwable);
            } else {
                causes.addLast(throwable);
            }
            throwable = throwable.getCause();
        }
        return causes;
    }

    public static RuntimeException toRuntimeException(Exception exception) {
        return ExceptionKit.toRuntimeException(exception, null);
    }

    public static RuntimeException toRuntimeException(Exception exception, Class<? extends RuntimeException> runtimeExceptionClass) {
        RuntimeException runtimeException;
        if (exception == null) {
            return null;
        }
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        if (runtimeExceptionClass == null) {
            return new RuntimeException(exception);
        }
        try {
            runtimeException = runtimeExceptionClass.newInstance();
        }
        catch (Exception ee) {
            return new RuntimeException(exception);
        }
        runtimeException.initCause(exception);
        return runtimeException;
    }

    public static void throwExceptionOrError(Throwable throwable) throws Exception {
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new RuntimeException(throwable);
    }

    public static void throwRuntimeExceptionOrError(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RuntimeException(throwable);
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        throwable.printStackTrace(out);
        out.flush();
        return buffer.toString();
    }
}

