/*
 * Decompiled with CFR 0.152.
 */
package blade.kit;

import blade.kit.Assert;
import blade.kit.StringKit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ClassLoaderKit {
    private static final Map<String, String> abbreviationMap = new HashMap<String, String>();

    public static ClassLoader getDefault() {
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loader == null && (loader = ClassLoaderKit.class.getClassLoader()) == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    public static Class<?> loadClass(String qualifiedClassName) {
        return ClassLoaderKit.loadClass(qualifiedClassName, null);
    }

    public static Class<?> loadClass(String qualifiedClassName, ClassLoader loader) {
        try {
            return ClassLoaderKit.loadClassEx(qualifiedClassName, loader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class<?> loadClassEx(String qualifiedClassName) throws ClassNotFoundException {
        return ClassLoaderKit.loadClassEx(qualifiedClassName, null);
    }

    public static Class<?> loadClassEx(String qualifiedClassName, ClassLoader classLoader) throws ClassNotFoundException {
        ClassLoader loader;
        Assert.notNull(qualifiedClassName, "qualifiedClassName must be not null");
        ClassLoader classLoader2 = loader = classLoader == null ? ClassLoaderKit.getDefault() : classLoader;
        if (abbreviationMap.containsKey(qualifiedClassName)) {
            String className = '[' + abbreviationMap.get(qualifiedClassName);
            return Class.forName(className, false, loader).getComponentType();
        }
        try {
            String className = ClassLoaderKit.getCanonicalClassName(qualifiedClassName);
            return Class.forName(className, false, loader);
        }
        catch (ClassNotFoundException className) {
            int ipos;
            if (qualifiedClassName.indexOf(36) == -1 && (ipos = qualifiedClassName.lastIndexOf(46)) > 0) {
                try {
                    String className2 = qualifiedClassName.substring(0, ipos) + '$' + qualifiedClassName.substring(ipos + 1);
                    className2 = ClassLoaderKit.getCanonicalClassName(className2);
                    return Class.forName(className2, false, loader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw new ClassNotFoundException(qualifiedClassName);
        }
    }

    public static String getCanonicalClassName(String qualifiedClassName) {
        Assert.notNull(qualifiedClassName, "qualifiedClassName must be not null");
        String name = StringKit.trimToEmpty(qualifiedClassName);
        if (name.endsWith("[]")) {
            StringBuilder sb = new StringBuilder();
            while (name.endsWith("[]")) {
                name = name.substring(0, name.length() - 2);
                sb.append('[');
            }
            String abbreviation = abbreviationMap.get(name);
            if (abbreviation != null) {
                sb.append(abbreviation);
            } else {
                sb.append('L').append(name).append(';');
            }
            name = sb.toString();
        }
        return name;
    }

    public static URL getResource(String name) {
        return ClassLoaderKit.getResource(name, null);
    }

    public static URL getResource(String name, ClassLoader classLoader) {
        URL url;
        URL url2;
        Assert.notNull(name, "resourceName must be not null");
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (classLoader != null && (url2 = classLoader.getResource(name)) != null) {
            return url2;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null && loader != classLoader && (url = loader.getResource(name)) != null) {
            return url;
        }
        return ClassLoader.getSystemResource(name);
    }

    public static InputStream getResourceAsStream(String name) throws IOException {
        return ClassLoaderKit.getResourceAsStream(name, null);
    }

    public static InputStream getResourceAsStream(String name, ClassLoader classLoader) throws IOException {
        URL url = ClassLoaderKit.getResource(name, classLoader);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    public static InputStream getClassAsStream(Class<?> clazz) throws IOException {
        return ClassLoaderKit.getResourceAsStream(ClassLoaderKit.getClassFileName(clazz), clazz.getClassLoader());
    }

    public static InputStream getClassAsStream(String qualifiedClassName) throws IOException {
        return ClassLoaderKit.getResourceAsStream(ClassLoaderKit.getClassFileName(qualifiedClassName));
    }

    public static String getClassFileName(Class<?> clazz) {
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return ClassLoaderKit.getClassFileName(clazz.getName());
    }

    public static String getClassFileName(String qualifiedClassName) {
        return qualifiedClassName.replace('.', '/') + ".class";
    }

    static {
        abbreviationMap.put("boolean", "Z");
        abbreviationMap.put("byte", "B");
        abbreviationMap.put("short", "S");
        abbreviationMap.put("char", "C");
        abbreviationMap.put("int", "I");
        abbreviationMap.put("long", "J");
        abbreviationMap.put("float", "F");
        abbreviationMap.put("double", "D");
    }
}

