/*
 * Decompiled with CFR 0.152.
 */
package blade.kit;

import blade.kit.StringKit;
import java.io.UnsupportedEncodingException;

public abstract class CharKit {
    private static final String CHAR_STRING = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f";
    private static final String[] CHAR_STRING_ARRAY = new String[128];
    private static final Character[] CHAR_ARRAY = new Character[128];

    public static int toAscii(char ch) {
        if (ch <= '\u00ff') {
            return ch;
        }
        return 63;
    }

    public static boolean isWhitespace(char ch) {
        return ch <= ' ';
    }

    public static Character toCharacterObject(char ch) {
        if (ch < CHAR_ARRAY.length) {
            return CHAR_ARRAY[ch];
        }
        return new Character(ch);
    }

    public static Character toCharacterObject(String str) {
        if (StringKit.isEmpty(str)) {
            return null;
        }
        return CharKit.toCharacterObject(str.charAt(0));
    }

    public static char toChar(byte b) {
        return (char)(b & 0xFF);
    }

    public static char toChar(Character ch) {
        if (ch == null) {
            throw new IllegalArgumentException("The Character must not be null");
        }
        return ch.charValue();
    }

    public static char toChar(Character ch, char defaultValue) {
        if (ch == null) {
            return defaultValue;
        }
        return ch.charValue();
    }

    public static char toChar(String str) {
        if (StringKit.isEmpty(str)) {
            throw new IllegalArgumentException("The String must not be empty");
        }
        return str.charAt(0);
    }

    public static char toChar(String str, char defaultValue) {
        if (StringKit.isEmpty(str)) {
            return defaultValue;
        }
        return str.charAt(0);
    }

    public static int toIntValue(char ch) {
        if (!CharKit.isDigit(ch)) {
            throw new IllegalArgumentException("The character " + ch + " is not in the range '0' - '9'");
        }
        return ch - 48;
    }

    public static int toIntValue(char ch, int defaultValue) {
        if (!CharKit.isDigit(ch)) {
            return defaultValue;
        }
        return ch - 48;
    }

    public static int toIntValue(Character ch) {
        if (ch == null) {
            throw new IllegalArgumentException("The character must not be null");
        }
        return CharKit.toIntValue(ch.charValue());
    }

    public static int toIntValue(Character ch, int defaultValue) {
        if (ch == null) {
            return defaultValue;
        }
        return CharKit.toIntValue(ch.charValue(), defaultValue);
    }

    public static String toString(char ch) {
        if (ch < '\u0080') {
            return CHAR_STRING_ARRAY[ch];
        }
        return new String(new char[]{ch});
    }

    public static String toString(Character ch) {
        if (ch == null) {
            return null;
        }
        return CharKit.toString(ch.charValue());
    }

    public static String unicodeEscaped(char ch) {
        if (ch < '\u0010') {
            return "\\u000" + Integer.toHexString(ch);
        }
        if (ch < '\u0100') {
            return "\\u00" + Integer.toHexString(ch);
        }
        if (ch < '\u1000') {
            return "\\u0" + Integer.toHexString(ch);
        }
        return "\\u" + Integer.toHexString(ch);
    }

    public static String unicodeEscaped(Character ch) {
        if (ch == null) {
            return null;
        }
        return CharKit.unicodeEscaped(ch.charValue());
    }

    public static byte[] toSimpleByteArray(char[] carr) {
        if (carr == null) {
            return null;
        }
        byte[] barr = new byte[carr.length];
        for (int i = 0; i < carr.length; ++i) {
            barr[i] = (byte)carr[i];
        }
        return barr;
    }

    public static byte[] toSimpleByteArray(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        byte[] barr = new byte[charSequence.length()];
        for (int i = 0; i < barr.length; ++i) {
            barr[i] = (byte)charSequence.charAt(i);
        }
        return barr;
    }

    public static char[] toSimpleCharArray(byte[] barr) {
        if (barr == null) {
            return null;
        }
        char[] carr = new char[barr.length];
        for (int i = 0; i < barr.length; ++i) {
            carr[i] = (char)(barr[i] & 0xFF);
        }
        return carr;
    }

    public static byte[] toAsciiByteArray(char[] carr) {
        if (carr == null) {
            return null;
        }
        byte[] barr = new byte[carr.length];
        for (int i = 0; i < carr.length; ++i) {
            barr[i] = (byte)(carr[i] <= '\u00ff' ? carr[i] : 63);
        }
        return barr;
    }

    public static byte[] toAsciiByteArray(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        byte[] barr = new byte[charSequence.length()];
        for (int i = 0; i < barr.length; ++i) {
            int c = charSequence.charAt(i);
            barr[i] = (byte)(c <= 255 ? c : 63);
        }
        return barr;
    }

    public static byte[] toRawByteArray(char[] carr) {
        if (carr == null) {
            return null;
        }
        byte[] barr = new byte[carr.length << 1];
        int bpos = 0;
        for (int i = 0; i < carr.length; ++i) {
            char c = carr[i];
            barr[bpos++] = (byte)((c & 0xFF00) >> 8);
            barr[bpos++] = (byte)(c & 0xFF);
        }
        return barr;
    }

    public static char[] toRawCharArray(byte[] barr) {
        if (barr == null) {
            return null;
        }
        int carrLen = barr.length >> 1;
        if (carrLen << 1 < barr.length) {
            ++carrLen;
        }
        char[] carr = new char[carrLen];
        int i = 0;
        int j = 0;
        while (i < barr.length) {
            char c = (char)(barr[i] << 8);
            if (++i != barr.length) {
                c = (char)(c + (barr[i] & 0xFF));
                ++i;
            }
            carr[j++] = c;
        }
        return carr;
    }

    public static byte[] toByteArray(char[] carr) throws UnsupportedEncodingException {
        if (carr == null) {
            return null;
        }
        return new String(carr).getBytes("UTF-8");
    }

    public static byte[] toByteArray(char[] carr, String charset) throws UnsupportedEncodingException {
        if (carr == null) {
            return null;
        }
        return new String(carr).getBytes(charset);
    }

    public static char[] toCharArray(byte[] barr) throws UnsupportedEncodingException {
        if (barr == null) {
            return null;
        }
        return new String(barr, "UTF-8").toCharArray();
    }

    public static char[] toCharArray(byte[] barr, String charset) throws UnsupportedEncodingException {
        if (barr == null) {
            return null;
        }
        return new String(barr, charset).toCharArray();
    }

    public static boolean equalsOne(char c, char[] match) {
        if (match == null) {
            return false;
        }
        for (char aMatch : match) {
            if (c != aMatch) continue;
            return true;
        }
        return false;
    }

    public static int findFirstEqual(char[] source, int index, char[] match) {
        if (source == null || match == null) {
            return -1;
        }
        int length = source.length;
        for (int i = index; i < length; ++i) {
            if (!CharKit.equalsOne(source[i], match)) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstEqual(char[] source, int index, char match) {
        if (source == null) {
            return -1;
        }
        for (int i = index; i < source.length; ++i) {
            if (source[i] != match) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstDiff(char[] source, int index, char[] match) {
        if (source == null || match == null) {
            return -1;
        }
        for (int i = index; i < source.length; ++i) {
            if (CharKit.equalsOne(source[i], match)) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstDiff(char[] source, int index, char match) {
        if (source == null) {
            return -1;
        }
        for (int i = index; i < source.length; ++i) {
            if (source[i] == match) continue;
            return i;
        }
        return -1;
    }

    public static boolean isLowercaseLetter(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isUppercaseLetter(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isLetterOrDigit(char c) {
        return CharKit.isDigit(c) || CharKit.isLetter(c);
    }

    public static boolean isWordChar(char c) {
        return CharKit.isDigit(c) || CharKit.isLetter(c) || c == '_';
    }

    public static boolean isPropertyNameChar(char c) {
        return CharKit.isDigit(c) || CharKit.isLetter(c) || c == '_' || c == '.' || c == '[' || c == ']';
    }

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static boolean isAsciiControl(char ch) {
        return ch < ' ' || ch == '\u007f';
    }

    public static boolean isChinese(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    public static char toUpperAscii(char c) {
        if (CharKit.isLowercaseLetter(c)) {
            c = (char)(c - 32);
        }
        return c;
    }

    public static char toLowerAscii(char c) {
        if (CharKit.isUppercaseLetter(c)) {
            c = (char)(c + 32);
        }
        return c;
    }

    static {
        for (int i = 127; i >= 0; --i) {
            CharKit.CHAR_STRING_ARRAY[i] = CHAR_STRING.substring(i, i + 1);
            CharKit.CHAR_ARRAY[i] = new Character((char)i);
        }
    }
}

